/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.util.ArrayDeque;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalBufferPool
implements BufferPool {
    private static final Logger LOG = LoggerFactory.getLogger(LocalBufferPool.class);
    private final NetworkBufferPool networkBufferPool;
    private final int numberOfRequiredMemorySegments;
    private final ArrayDeque<MemorySegment> availableMemorySegments = new ArrayDeque();
    private final ArrayDeque<BufferListener> registeredListeners = new ArrayDeque();
    private final int maxNumberOfMemorySegments;
    private int currentPoolSize;
    private int numberOfRequestedMemorySegments;
    private boolean isDestroyed;
    private BufferPoolOwner owner;

    LocalBufferPool(NetworkBufferPool networkBufferPool, int numberOfRequiredMemorySegments) {
        this(networkBufferPool, numberOfRequiredMemorySegments, Integer.MAX_VALUE);
    }

    LocalBufferPool(NetworkBufferPool networkBufferPool, int numberOfRequiredMemorySegments, int maxNumberOfMemorySegments) {
        Preconditions.checkArgument((maxNumberOfMemorySegments >= numberOfRequiredMemorySegments ? 1 : 0) != 0, (String)"Maximum number of memory segments (%s) should not be smaller than minimum (%s).", (Object[])new Object[]{maxNumberOfMemorySegments, numberOfRequiredMemorySegments});
        Preconditions.checkArgument((maxNumberOfMemorySegments > 0 ? 1 : 0) != 0, (String)"Maximum number of memory segments (%s) should be larger than 0.", (Object[])new Object[]{maxNumberOfMemorySegments});
        LOG.debug("Using a local buffer pool with {}-{} buffers", (Object)numberOfRequiredMemorySegments, (Object)maxNumberOfMemorySegments);
        this.networkBufferPool = networkBufferPool;
        this.numberOfRequiredMemorySegments = numberOfRequiredMemorySegments;
        this.currentPoolSize = numberOfRequiredMemorySegments;
        this.maxNumberOfMemorySegments = maxNumberOfMemorySegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            return this.isDestroyed;
        }
    }

    @Override
    public int getMemorySegmentSize() {
        return this.networkBufferPool.getMemorySegmentSize();
    }

    @Override
    public int getNumberOfRequiredMemorySegments() {
        return this.numberOfRequiredMemorySegments;
    }

    @Override
    public int getMaxNumberOfMemorySegments() {
        return this.maxNumberOfMemorySegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfAvailableMemorySegments() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            return this.availableMemorySegments.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumBuffers() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            return this.currentPoolSize;
        }
    }

    @Override
    public int bestEffortGetNumOfUsedBuffers() {
        return Math.max(0, this.numberOfRequestedMemorySegments - this.availableMemorySegments.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferPoolOwner(BufferPoolOwner owner) {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            Preconditions.checkState((this.owner == null ? 1 : 0) != 0, (Object)"Buffer pool owner has already been set.");
            this.owner = (BufferPoolOwner)Preconditions.checkNotNull((Object)owner);
        }
    }

    @Override
    public Buffer requestBuffer() throws IOException {
        try {
            return this.toBuffer(this.requestMemorySegment(false));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Buffer requestBufferBlocking() throws IOException, InterruptedException {
        return this.toBuffer(this.requestMemorySegment(true));
    }

    @Override
    public BufferBuilder requestBufferBuilderBlocking() throws IOException, InterruptedException {
        return this.toBufferBuilder(this.requestMemorySegment(true));
    }

    private Buffer toBuffer(MemorySegment memorySegment) {
        if (memorySegment == null) {
            return null;
        }
        return new NetworkBuffer(memorySegment, this);
    }

    private BufferBuilder toBufferBuilder(MemorySegment memorySegment) {
        if (memorySegment == null) {
            return null;
        }
        return new BufferBuilder(memorySegment, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemorySegment requestMemorySegment(boolean isBlocking) throws InterruptedException, IOException {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            boolean askToRecycle;
            this.returnExcessMemorySegments();
            boolean bl = askToRecycle = this.owner != null;
            while (this.availableMemorySegments.isEmpty()) {
                MemorySegment segment;
                if (this.isDestroyed) {
                    throw new IllegalStateException("Buffer pool is destroyed.");
                }
                if (this.numberOfRequestedMemorySegments < this.currentPoolSize && (segment = this.networkBufferPool.requestMemorySegment()) != null) {
                    ++this.numberOfRequestedMemorySegments;
                    return segment;
                }
                if (askToRecycle) {
                    this.owner.releaseMemory(1);
                }
                if (isBlocking) {
                    this.availableMemorySegments.wait(2000L);
                    continue;
                }
                return null;
            }
            return this.availableMemorySegments.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(MemorySegment segment) {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            if (this.isDestroyed || this.numberOfRequestedMemorySegments > this.currentPoolSize) {
                this.returnMemorySegment(segment);
            } else {
                BufferListener listener = this.registeredListeners.poll();
                if (listener == null) {
                    this.availableMemorySegments.add(segment);
                    this.availableMemorySegments.notify();
                } else {
                    try {
                        boolean needMoreBuffers = listener.notifyBufferAvailable(new NetworkBuffer(segment, this));
                        if (needMoreBuffers) {
                            this.registeredListeners.add(listener);
                        }
                    }
                    catch (Throwable ignored) {
                        this.availableMemorySegments.add(segment);
                        this.availableMemorySegments.notify();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lazyDestroy() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            if (!this.isDestroyed) {
                BufferListener listener;
                MemorySegment segment;
                while ((segment = this.availableMemorySegments.poll()) != null) {
                    this.returnMemorySegment(segment);
                }
                while ((listener = this.registeredListeners.poll()) != null) {
                    listener.notifyBufferDestroyed();
                }
                this.isDestroyed = true;
            }
        }
        this.networkBufferPool.destroyBufferPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBufferListener(BufferListener listener) {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            if (!this.availableMemorySegments.isEmpty() || this.isDestroyed) {
                return false;
            }
            this.registeredListeners.add(listener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumBuffers(int numBuffers) throws IOException {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            Preconditions.checkArgument((numBuffers >= this.numberOfRequiredMemorySegments ? 1 : 0) != 0, (String)"Buffer pool needs at least %s buffers, but tried to set to %s", (Object[])new Object[]{this.numberOfRequiredMemorySegments, numBuffers});
            this.currentPoolSize = numBuffers > this.maxNumberOfMemorySegments ? this.maxNumberOfMemorySegments : numBuffers;
            this.returnExcessMemorySegments();
            if (this.owner != null && this.numberOfRequestedMemorySegments > this.currentPoolSize) {
                this.owner.releaseMemory(this.numberOfRequestedMemorySegments - numBuffers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            return String.format("[size: %d, required: %d, requested: %d, available: %d, max: %d, listeners: %d, destroyed: %s]", this.currentPoolSize, this.numberOfRequiredMemorySegments, this.numberOfRequestedMemorySegments, this.availableMemorySegments.size(), this.maxNumberOfMemorySegments, this.registeredListeners.size(), this.isDestroyed);
        }
    }

    private void returnMemorySegment(MemorySegment segment) {
        assert (Thread.holdsLock(this.availableMemorySegments));
        --this.numberOfRequestedMemorySegments;
        this.networkBufferPool.recycle(segment);
    }

    private void returnExcessMemorySegments() {
        assert (Thread.holdsLock(this.availableMemorySegments));
        while (this.numberOfRequestedMemorySegments > this.currentPoolSize) {
            MemorySegment segment = this.availableMemorySegments.poll();
            if (segment == null) {
                return;
            }
            this.returnMemorySegment(segment);
        }
    }
}

