/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterConfiguration;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobNotFinishedException;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerRunner
implements LeaderContender,
OnCompletionActions,
AutoCloseableAsync {
    private static final Logger log = LoggerFactory.getLogger(JobManagerRunner.class);
    private final Object lock = new Object();
    private final JobGraph jobGraph;
    private final RunningJobsRegistry runningJobsRegistry;
    private final LeaderElectionService leaderElectionService;
    private final JobManagerSharedServices jobManagerSharedServices;
    private final JobMaster jobMaster;
    private final FatalErrorHandler fatalErrorHandler;
    private final Time rpcTimeout;
    private final CompletableFuture<ArchivedExecutionGraph> resultFuture = new CompletableFuture();
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private volatile boolean shutdown;
    private volatile CompletableFuture<JobMasterGateway> leaderGatewayFuture;

    public JobManagerRunner(ResourceID resourceId, JobGraph jobGraph, Configuration configuration, RpcService rpcService, HighAvailabilityServices haServices, HeartbeatServices heartbeatServices, BlobServer blobServer, JobManagerSharedServices jobManagerSharedServices, JobManagerJobMetricGroupFactory jobManagerJobMetricGroupFactory, FatalErrorHandler fatalErrorHandler) throws Exception {
        try {
            this.jobGraph = (JobGraph)Preconditions.checkNotNull((Object)jobGraph);
            this.jobManagerSharedServices = (JobManagerSharedServices)Preconditions.checkNotNull((Object)jobManagerSharedServices);
            this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
            Preconditions.checkArgument((jobGraph.getNumberOfVertices() > 0 ? 1 : 0) != 0, (Object)"The given job is empty");
            LibraryCacheManager libraryCacheManager = jobManagerSharedServices.getLibraryCacheManager();
            try {
                libraryCacheManager.registerJob(jobGraph.getJobID(), jobGraph.getUserJarBlobKeys(), jobGraph.getClasspaths());
            }
            catch (IOException e) {
                throw new Exception("Cannot set up the user code libraries: " + e.getMessage(), e);
            }
            ClassLoader userCodeLoader = libraryCacheManager.getClassLoader(jobGraph.getJobID());
            if (userCodeLoader == null) {
                throw new Exception("The user code class loader could not be initialized.");
            }
            this.runningJobsRegistry = haServices.getRunningJobsRegistry();
            this.leaderElectionService = haServices.getJobManagerLeaderElectionService(jobGraph.getJobID());
            JobMasterConfiguration jobMasterConfiguration = JobMasterConfiguration.fromConfiguration(configuration);
            this.rpcTimeout = jobMasterConfiguration.getRpcTimeout();
            this.leaderGatewayFuture = new CompletableFuture();
            this.jobMaster = new JobMaster(rpcService, jobMasterConfiguration, resourceId, jobGraph, haServices, jobManagerSharedServices, heartbeatServices, blobServer, jobManagerJobMetricGroupFactory, this, fatalErrorHandler, userCodeLoader);
        }
        catch (Throwable t) {
            this.terminationFuture.completeExceptionally(t);
            this.resultFuture.completeExceptionally(t);
            throw new JobExecutionException(jobGraph.getJobID(), "Could not set up JobManager", t);
        }
    }

    public CompletableFuture<JobMasterGateway> getLeaderGatewayFuture() {
        return this.leaderGatewayFuture;
    }

    public JobGraph getJobGraph() {
        return this.jobGraph;
    }

    public CompletableFuture<ArchivedExecutionGraph> getResultFuture() {
        return this.resultFuture;
    }

    public void start() throws Exception {
        try {
            this.leaderElectionService.start(this);
        }
        catch (Exception e) {
            log.error("Could not start the JobManager because the leader election service did not start.", (Throwable)e);
            throw new Exception("Could not start the leader election service.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                this.setNewLeaderGatewayFuture();
                this.leaderGatewayFuture.completeExceptionally(new FlinkException("JobMaster has been shut down."));
                this.jobMaster.shutDown();
                CompletableFuture<Void> jobManagerTerminationFuture = this.jobMaster.getTerminationFuture();
                jobManagerTerminationFuture.whenComplete((ignored, throwable) -> {
                    try {
                        this.leaderElectionService.stop();
                    }
                    catch (Throwable t) {
                        throwable = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)ExceptionUtils.stripCompletionException((Throwable)throwable));
                    }
                    LibraryCacheManager libraryCacheManager = this.jobManagerSharedServices.getLibraryCacheManager();
                    libraryCacheManager.unregisterJob(this.jobGraph.getJobID());
                    if (throwable != null) {
                        this.terminationFuture.completeExceptionally(new FlinkException("Could not properly shut down the JobManagerRunner", throwable));
                    } else {
                        this.terminationFuture.complete(null);
                    }
                });
                this.terminationFuture.whenComplete((ignored, throwable) -> this.resultFuture.completeExceptionally((Throwable)((Object)new JobNotFinishedException(this.jobGraph.getJobID()))));
            }
            return this.terminationFuture;
        }
    }

    @Override
    public void jobReachedGloballyTerminalState(ArchivedExecutionGraph executionGraph) {
        this.unregisterJobFromHighAvailability();
        this.resultFuture.complete(executionGraph);
    }

    @Override
    public void jobFinishedByOther() {
        this.resultFuture.completeExceptionally((Throwable)((Object)new JobNotFinishedException(this.jobGraph.getJobID())));
    }

    @Override
    public void jobMasterFailed(Throwable cause) {
        this.handleJobManagerRunnerError(cause);
    }

    private void handleJobManagerRunnerError(Throwable cause) {
        if (ExceptionUtils.isJvmFatalError((Throwable)cause)) {
            this.fatalErrorHandler.onFatalError(cause);
        } else {
            this.resultFuture.completeExceptionally(cause);
        }
    }

    private void unregisterJobFromHighAvailability() {
        try {
            this.runningJobsRegistry.setJobFinished(this.jobGraph.getJobID());
        }
        catch (Throwable t) {
            log.error("Could not un-register from high-availability services job {} ({}).Other JobManager's may attempt to recover it and re-execute it.", new Object[]{this.jobGraph.getName(), this.jobGraph.getJobID(), t});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantLeadership(UUID leaderSessionID) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                log.info("JobManagerRunner already shutdown.");
                return;
            }
            try {
                this.verifyJobSchedulingStatusAndStartJobManager(leaderSessionID);
            }
            catch (Exception e) {
                this.handleJobManagerRunnerError(e);
            }
        }
    }

    private void verifyJobSchedulingStatusAndStartJobManager(UUID leaderSessionId) throws Exception {
        RunningJobsRegistry.JobSchedulingStatus jobSchedulingStatus = this.runningJobsRegistry.getJobSchedulingStatus(this.jobGraph.getJobID());
        if (jobSchedulingStatus == RunningJobsRegistry.JobSchedulingStatus.DONE) {
            log.info("Granted leader ship but job {} has been finished. ", (Object)this.jobGraph.getJobID());
            this.jobFinishedByOther();
        } else {
            log.info("JobManager runner for job {} ({}) was granted leadership with session id {} at {}.", new Object[]{this.jobGraph.getName(), this.jobGraph.getJobID(), leaderSessionId, this.getAddress()});
            this.runningJobsRegistry.setJobRunning(this.jobGraph.getJobID());
            CompletableFuture<Acknowledge> startFuture = this.jobMaster.start(new JobMasterId(leaderSessionId), this.rpcTimeout);
            CompletableFuture<JobMasterGateway> currentLeaderGatewayFuture = this.leaderGatewayFuture;
            startFuture.whenCompleteAsync((ack, throwable) -> {
                if (throwable != null) {
                    this.handleJobManagerRunnerError(new FlinkException("Could not start the job manager.", throwable));
                } else {
                    this.confirmLeaderSessionIdIfStillLeader(leaderSessionId, currentLeaderGatewayFuture);
                }
            }, (Executor)this.jobManagerSharedServices.getScheduledExecutorService());
        }
    }

    private void confirmLeaderSessionIdIfStillLeader(UUID leaderSessionId, CompletableFuture<JobMasterGateway> currentLeaderGatewayFuture) {
        if (this.leaderElectionService.hasLeadership()) {
            currentLeaderGatewayFuture.complete(this.jobMaster.getSelfGateway(JobMasterGateway.class));
            this.leaderElectionService.confirmLeaderSessionID(leaderSessionId);
        } else {
            log.debug("Ignoring confirmation of leader session id because {} is no longer the leader.", (Object)this.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeLeadership() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                log.info("JobManagerRunner already shutdown.");
                return;
            }
            log.info("JobManager for job {} ({}) was revoked leadership at {}.", new Object[]{this.jobGraph.getName(), this.jobGraph.getJobID(), this.getAddress()});
            this.setNewLeaderGatewayFuture();
            CompletableFuture<Acknowledge> suspendFuture = this.jobMaster.suspend((Exception)((Object)new FlinkException("JobManager is no longer the leader.")), this.rpcTimeout);
            suspendFuture.whenCompleteAsync((ack, throwable) -> {
                if (throwable != null) {
                    this.handleJobManagerRunnerError(new FlinkException("Could not suspend the job manager.", throwable));
                }
            }, (Executor)this.jobManagerSharedServices.getScheduledExecutorService());
        }
    }

    private void setNewLeaderGatewayFuture() {
        CompletableFuture<JobMasterGateway> oldLeaderGatewayFuture = this.leaderGatewayFuture;
        this.leaderGatewayFuture = new CompletableFuture();
        if (!oldLeaderGatewayFuture.isDone()) {
            this.leaderGatewayFuture.whenComplete((jobMasterGateway, throwable) -> {
                if (throwable != null) {
                    oldLeaderGatewayFuture.completeExceptionally((Throwable)throwable);
                } else {
                    oldLeaderGatewayFuture.complete((JobMasterGateway)jobMasterGateway);
                }
            });
        }
    }

    @Override
    public String getAddress() {
        return this.jobMaster.getAddress();
    }

    @Override
    public void handleError(Exception exception) {
        log.error("Leader Election Service encountered a fatal error.", (Throwable)exception);
        this.handleJobManagerRunnerError(exception);
    }

    @VisibleForTesting
    boolean isShutdown() {
        return this.shutdown;
    }
}

