/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.util.Preconditions;

public class JobMasterConfiguration {
    private final Time rpcTimeout;
    private final Time slotRequestTimeout;
    private final Time slotIdleTimeout;
    private final String tmpDirectory;
    private final Configuration configuration;

    public JobMasterConfiguration(Time rpcTimeout, Time slotRequestTimeout, Time slotIdleTimeout, String tmpDirectory, Configuration configuration) {
        this.rpcTimeout = (Time)Preconditions.checkNotNull((Object)rpcTimeout);
        this.slotRequestTimeout = (Time)Preconditions.checkNotNull((Object)slotRequestTimeout);
        this.slotIdleTimeout = (Time)Preconditions.checkNotNull((Object)slotIdleTimeout);
        this.tmpDirectory = (String)Preconditions.checkNotNull((Object)tmpDirectory);
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
    }

    public Time getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Time getSlotRequestTimeout() {
        return this.slotRequestTimeout;
    }

    public Time getSlotIdleTimeout() {
        return this.slotIdleTimeout;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static JobMasterConfiguration fromConfiguration(Configuration configuration) {
        Time rpcTimeout;
        try {
            rpcTimeout = Time.milliseconds((long)AkkaUtils.getTimeout(configuration).toMillis());
        }
        catch (NumberFormatException e) {
            throw new IllegalConfigurationException(AkkaUtils.formatDurationParsingErrorMessage());
        }
        Time slotRequestTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT));
        Time slotIdleTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_IDLE_TIMEOUT));
        String tmpDirectory = ConfigurationUtils.parseTempDirectories((Configuration)configuration)[0];
        return new JobMasterConfiguration(rpcTimeout, slotRequestTimeout, slotIdleTimeout, tmpDirectory, configuration);
    }
}

