/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerRunner
implements FatalErrorHandler,
AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerRunner.class);
    private final Object lock = new Object();
    private final ResourceManagerRuntimeServices resourceManagerRuntimeServices;
    private final ResourceManager<?> resourceManager;

    public ResourceManagerRunner(ResourceID resourceId, String resourceManagerEndpointId, Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, ClusterInformation clusterInformation) throws Exception {
        Preconditions.checkNotNull((Object)resourceId);
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)rpcService);
        Preconditions.checkNotNull((Object)highAvailabilityServices);
        Preconditions.checkNotNull((Object)heartbeatServices);
        Preconditions.checkNotNull((Object)metricRegistry);
        ResourceManagerConfiguration resourceManagerConfiguration = ResourceManagerConfiguration.fromConfiguration(configuration);
        ResourceManagerRuntimeServicesConfiguration resourceManagerRuntimeServicesConfiguration = ResourceManagerRuntimeServicesConfiguration.fromConfiguration(configuration);
        this.resourceManagerRuntimeServices = ResourceManagerRuntimeServices.fromConfiguration(resourceManagerRuntimeServicesConfiguration, highAvailabilityServices, rpcService.getScheduledExecutor());
        this.resourceManager = new StandaloneResourceManager(rpcService, resourceManagerEndpointId, resourceId, resourceManagerConfiguration, highAvailabilityServices, heartbeatServices, this.resourceManagerRuntimeServices.getSlotManager(), metricRegistry, this.resourceManagerRuntimeServices.getJobLeaderIdService(), clusterInformation, this);
    }

    public ResourceManagerGateway getResourceManageGateway() {
        return this.resourceManager.getSelfGateway(ResourceManagerGateway.class);
    }

    public void start() throws Exception {
        this.resourceManager.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            this.resourceManager.shutDown();
            return this.resourceManager.getTerminationFuture();
        }
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Encountered fatal error.", exception);
        CompletableFuture<Void> shutdownFuture = this.closeAsync();
        shutdownFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                LOG.error("Could not properly shut down the resource manager runner.", throwable);
            }
        });
    }
}

