/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Handler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Router;

public class RouterHandler
extends Handler {
    private final Map<String, String> responseHeaders;

    public RouterHandler(Router router, Map<String, String> responseHeaders) {
        super(router);
        this.responseHeaders = Objects.requireNonNull(responseHeaders);
    }

    protected void respondNotFound(ChannelHandlerContext ctx, HttpRequest request) {
        HandlerUtils.sendErrorResponse(ctx, request, new ErrorResponseBody("Not found."), HttpResponseStatus.NOT_FOUND, this.responseHeaders);
    }
}

