/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public final class JobSubmitRequestBody
implements RequestBody {
    private static final String FIELD_NAME_SERIALIZED_JOB_GRAPH = "serializedJobGraph";
    @JsonProperty(value="serializedJobGraph")
    public final byte[] serializedJobGraph;

    public JobSubmitRequestBody(JobGraph jobGraph) throws IOException {
        this(JobSubmitRequestBody.serializeJobGraph(jobGraph));
    }

    @JsonCreator
    public JobSubmitRequestBody(@JsonProperty(value="serializedJobGraph") byte[] serializedJobGraph) {
        this.serializedJobGraph = (byte[])Preconditions.checkNotNull((Object)serializedJobGraph);
    }

    public int hashCode() {
        return 71 * Arrays.hashCode(this.serializedJobGraph);
    }

    public boolean equals(Object object) {
        if (object instanceof JobSubmitRequestBody) {
            JobSubmitRequestBody other = (JobSubmitRequestBody)object;
            return Arrays.equals(this.serializedJobGraph, other.serializedJobGraph);
        }
        return false;
    }

    private static byte[] serializeJobGraph(JobGraph jobGraph) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);){
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(jobGraph);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }
}

