/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredBroadcastBackendStateMetaInfo;
import org.apache.flink.runtime.state.RegisteredOperatorBackendStateMetaInfo;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorBackendStateMetaInfoSnapshotReaderWriters {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorBackendStateMetaInfoSnapshotReaderWriters.class);

    public static <S> OperatorBackendStateMetaInfoWriter getOperatorStateWriterForVersion(int version, RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo) {
        switch (version) {
            case 1: {
                return new OperatorBackendStateMetaInfoWriterV1<S>(stateMetaInfo);
            }
            case 2: 
            case 3: {
                return new OperatorBackendStateMetaInfoWriterV2<S>(stateMetaInfo);
            }
        }
        throw new IllegalStateException("Unrecognized operator backend state meta info writer version: " + version);
    }

    public static <K, V> BroadcastStateMetaInfoWriter getBroadcastStateWriterForVersion(int version, RegisteredBroadcastBackendStateMetaInfo.Snapshot<K, V> broadcastStateMetaInfo) {
        switch (version) {
            case 3: {
                return new BroadcastStateMetaInfoWriterV3<K, V>(broadcastStateMetaInfo);
            }
        }
        throw new IllegalStateException("Unrecognized broadcast state meta info writer version: " + version);
    }

    public static <S> OperatorBackendStateMetaInfoReader<S> getOperatorStateReaderForVersion(int version, ClassLoader userCodeClassLoader) {
        switch (version) {
            case 1: {
                return new OperatorBackendStateMetaInfoReaderV1(userCodeClassLoader);
            }
            case 2: 
            case 3: {
                return new OperatorBackendStateMetaInfoReaderV2(userCodeClassLoader);
            }
        }
        throw new IllegalStateException("Unrecognized operator backend state meta info reader version: " + version);
    }

    public static <K, V> BroadcastStateMetaInfoReader<K, V> getBroadcastStateReaderForVersion(int version, ClassLoader userCodeClassLoader) {
        switch (version) {
            case 3: {
                return new BroadcastStateMetaInfoReaderV3(userCodeClassLoader);
            }
        }
        throw new IllegalStateException("Unrecognized broadcast state meta info reader version: " + version);
    }

    public static class BroadcastStateMetaInfoReaderV3<K, V>
    extends AbstractBroadcastStateMetaInfoReader<K, V> {
        public BroadcastStateMetaInfoReaderV3(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        public RegisteredBroadcastBackendStateMetaInfo.Snapshot<K, V> readBroadcastStateMetaInfo(DataInputView in) throws IOException {
            RegisteredBroadcastBackendStateMetaInfo.Snapshot stateMetaInfo = new RegisteredBroadcastBackendStateMetaInfo.Snapshot();
            stateMetaInfo.setName(in.readUTF());
            stateMetaInfo.setAssignmentMode(OperatorStateHandle.Mode.values()[in.readByte()]);
            List serializers = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)this.userCodeClassLoader);
            Tuple2 keySerializerAndConfig = (Tuple2)serializers.get(0);
            Tuple2 valueSerializerAndConfig = (Tuple2)serializers.get(1);
            stateMetaInfo.setKeySerializer((TypeSerializer)keySerializerAndConfig.f0);
            stateMetaInfo.setKeySerializerConfigSnapshot((TypeSerializerConfigSnapshot)keySerializerAndConfig.f1);
            stateMetaInfo.setValueSerializer((TypeSerializer)valueSerializerAndConfig.f0);
            stateMetaInfo.setValueSerializerConfigSnapshot((TypeSerializerConfigSnapshot)valueSerializerAndConfig.f1);
            return stateMetaInfo;
        }
    }

    public static class OperatorBackendStateMetaInfoReaderV2<S>
    extends AbstractOperatorBackendStateMetaInfoReader<S> {
        public OperatorBackendStateMetaInfoReaderV2(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        public RegisteredOperatorBackendStateMetaInfo.Snapshot<S> readOperatorStateMetaInfo(DataInputView in) throws IOException {
            RegisteredOperatorBackendStateMetaInfo.Snapshot stateMetaInfo = new RegisteredOperatorBackendStateMetaInfo.Snapshot();
            stateMetaInfo.setName(in.readUTF());
            stateMetaInfo.setAssignmentMode(OperatorStateHandle.Mode.values()[in.readByte()]);
            Tuple2 stateSerializerAndConfig = (Tuple2)TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)this.userCodeClassLoader).get(0);
            stateMetaInfo.setPartitionStateSerializer((TypeSerializer)stateSerializerAndConfig.f0);
            stateMetaInfo.setPartitionStateSerializerConfigSnapshot((TypeSerializerConfigSnapshot)stateSerializerAndConfig.f1);
            return stateMetaInfo;
        }
    }

    public static class OperatorBackendStateMetaInfoReaderV1<S>
    extends AbstractOperatorBackendStateMetaInfoReader<S> {
        public OperatorBackendStateMetaInfoReaderV1(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        public RegisteredOperatorBackendStateMetaInfo.Snapshot<S> readOperatorStateMetaInfo(DataInputView in) throws IOException {
            RegisteredOperatorBackendStateMetaInfo.Snapshot stateMetaInfo = new RegisteredOperatorBackendStateMetaInfo.Snapshot();
            stateMetaInfo.setName(in.readUTF());
            stateMetaInfo.setAssignmentMode(OperatorStateHandle.Mode.values()[in.readByte()]);
            DataInputViewStream dis = new DataInputViewStream(in);
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            try (InstantiationUtil.FailureTolerantObjectInputStream ois = new InstantiationUtil.FailureTolerantObjectInputStream((InputStream)dis, this.userCodeClassLoader);){
                Thread.currentThread().setContextClassLoader(this.userCodeClassLoader);
                TypeSerializer stateSerializer = (TypeSerializer)ois.readObject();
                stateMetaInfo.setPartitionStateSerializer(stateSerializer);
            }
            catch (ClassNotFoundException exception) {
                throw new IOException(exception);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
            stateMetaInfo.setPartitionStateSerializerConfigSnapshot(null);
            return stateMetaInfo;
        }
    }

    public static abstract class AbstractBroadcastStateMetaInfoReader<K, V>
    implements BroadcastStateMetaInfoReader<K, V> {
        protected final ClassLoader userCodeClassLoader;

        public AbstractBroadcastStateMetaInfoReader(ClassLoader userCodeClassLoader) {
            this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        }
    }

    public static abstract class AbstractOperatorBackendStateMetaInfoReader<S>
    implements OperatorBackendStateMetaInfoReader<S> {
        protected final ClassLoader userCodeClassLoader;

        public AbstractOperatorBackendStateMetaInfoReader(ClassLoader userCodeClassLoader) {
            this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        }
    }

    public static interface BroadcastStateMetaInfoReader<K, V> {
        public RegisteredBroadcastBackendStateMetaInfo.Snapshot<K, V> readBroadcastStateMetaInfo(DataInputView var1) throws IOException;
    }

    public static interface OperatorBackendStateMetaInfoReader<S> {
        public RegisteredOperatorBackendStateMetaInfo.Snapshot<S> readOperatorStateMetaInfo(DataInputView var1) throws IOException;
    }

    public static class BroadcastStateMetaInfoWriterV3<K, V>
    extends AbstractBroadcastStateMetaInfoWriter<K, V> {
        public BroadcastStateMetaInfoWriterV3(RegisteredBroadcastBackendStateMetaInfo.Snapshot<K, V> broadcastStateMetaInfo) {
            super(broadcastStateMetaInfo);
        }

        @Override
        public void writeBroadcastStateMetaInfo(DataOutputView out) throws IOException {
            out.writeUTF(this.broadcastStateMetaInfo.getName());
            out.writeByte(this.broadcastStateMetaInfo.getAssignmentMode().ordinal());
            TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Arrays.asList(Tuple2.of(this.broadcastStateMetaInfo.getKeySerializer(), (Object)this.broadcastStateMetaInfo.getKeySerializerConfigSnapshot()), Tuple2.of(this.broadcastStateMetaInfo.getValueSerializer(), (Object)this.broadcastStateMetaInfo.getValueSerializerConfigSnapshot())));
        }
    }

    public static class OperatorBackendStateMetaInfoWriterV2<S>
    extends AbstractOperatorBackendStateMetaInfoWriter<S> {
        public OperatorBackendStateMetaInfoWriterV2(RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo) {
            super(stateMetaInfo);
        }

        @Override
        public void writeOperatorStateMetaInfo(DataOutputView out) throws IOException {
            out.writeUTF(this.stateMetaInfo.getName());
            out.writeByte(this.stateMetaInfo.getAssignmentMode().ordinal());
            TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Collections.singletonList(new Tuple2(this.stateMetaInfo.getPartitionStateSerializer(), (Object)this.stateMetaInfo.getPartitionStateSerializerConfigSnapshot())));
        }
    }

    public static class OperatorBackendStateMetaInfoWriterV1<S>
    extends AbstractOperatorBackendStateMetaInfoWriter<S> {
        public OperatorBackendStateMetaInfoWriterV1(RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo) {
            super(stateMetaInfo);
        }

        @Override
        public void writeOperatorStateMetaInfo(DataOutputView out) throws IOException {
            out.writeUTF(this.stateMetaInfo.getName());
            out.writeByte(this.stateMetaInfo.getAssignmentMode().ordinal());
            TypeSerializerSerializationUtil.writeSerializer((DataOutputView)out, this.stateMetaInfo.getPartitionStateSerializer());
        }
    }

    public static abstract class AbstractBroadcastStateMetaInfoWriter<K, V>
    implements BroadcastStateMetaInfoWriter {
        protected final RegisteredBroadcastBackendStateMetaInfo.Snapshot<K, V> broadcastStateMetaInfo;

        public AbstractBroadcastStateMetaInfoWriter(RegisteredBroadcastBackendStateMetaInfo.Snapshot<K, V> broadcastStateMetaInfo) {
            this.broadcastStateMetaInfo = (RegisteredBroadcastBackendStateMetaInfo.Snapshot)Preconditions.checkNotNull(broadcastStateMetaInfo);
        }
    }

    public static abstract class AbstractOperatorBackendStateMetaInfoWriter<S>
    implements OperatorBackendStateMetaInfoWriter {
        protected final RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo;

        public AbstractOperatorBackendStateMetaInfoWriter(RegisteredOperatorBackendStateMetaInfo.Snapshot<S> stateMetaInfo) {
            this.stateMetaInfo = (RegisteredOperatorBackendStateMetaInfo.Snapshot)Preconditions.checkNotNull(stateMetaInfo);
        }
    }

    public static interface BroadcastStateMetaInfoWriter {
        public void writeBroadcastStateMetaInfo(DataOutputView var1) throws IOException;
    }

    public static interface OperatorBackendStateMetaInfoWriter {
        public void writeOperatorStateMetaInfo(DataOutputView var1) throws IOException;
    }
}

