/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.DefaultOperatorStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateBackend;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorage;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class FsStateBackend
extends AbstractFileStateBackend
implements ConfigurableStateBackend {
    private static final long serialVersionUID = -8191916350224044011L;
    public static final int MAX_FILE_STATE_THRESHOLD = 0x100000;
    private final int fileStateThreshold;
    private final TernaryBoolean asynchronousSnapshots;

    public FsStateBackend(String checkpointDataUri) {
        this(new Path(checkpointDataUri));
    }

    public FsStateBackend(String checkpointDataUri, boolean asynchronousSnapshots) {
        this(new Path(checkpointDataUri), asynchronousSnapshots);
    }

    public FsStateBackend(Path checkpointDataUri) {
        this(checkpointDataUri.toUri());
    }

    public FsStateBackend(Path checkpointDataUri, boolean asynchronousSnapshots) {
        this(checkpointDataUri.toUri(), asynchronousSnapshots);
    }

    public FsStateBackend(URI checkpointDataUri) {
        this(checkpointDataUri, null, -1, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, @Nullable URI defaultSavepointDirectory) {
        this(checkpointDataUri, defaultSavepointDirectory, -1, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, boolean asynchronousSnapshots) {
        this(checkpointDataUri, null, -1, TernaryBoolean.fromBoolean((boolean)asynchronousSnapshots));
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold) {
        this(checkpointDataUri, null, fileStateSizeThreshold, TernaryBoolean.UNDEFINED);
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold, boolean asynchronousSnapshots) {
        this(checkpointDataUri, null, fileStateSizeThreshold, TernaryBoolean.fromBoolean((boolean)asynchronousSnapshots));
    }

    public FsStateBackend(URI checkpointDirectory, @Nullable URI defaultSavepointDirectory, int fileStateSizeThreshold, TernaryBoolean asynchronousSnapshots) {
        super((URI)Preconditions.checkNotNull((Object)checkpointDirectory, (String)"checkpoint directory is null"), defaultSavepointDirectory);
        Preconditions.checkNotNull((Object)asynchronousSnapshots, (String)"asynchronousSnapshots");
        Preconditions.checkArgument((fileStateSizeThreshold >= -1 && fileStateSizeThreshold <= 0x100000 ? 1 : 0) != 0, (String)"The threshold for file state size must be in [-1, %s], where '-1' means to use the value from the deployment's configuration.", (Object[])new Object[]{0x100000});
        this.fileStateThreshold = fileStateSizeThreshold;
        this.asynchronousSnapshots = asynchronousSnapshots;
    }

    private FsStateBackend(FsStateBackend original, Configuration configuration) {
        super(original.getCheckpointPath(), original.getSavepointPath(), configuration);
        int sizeThreshold;
        this.asynchronousSnapshots = original.asynchronousSnapshots.resolveUndefined(configuration.getBoolean(CheckpointingOptions.ASYNC_SNAPSHOTS));
        int n = sizeThreshold = original.fileStateThreshold >= 0 ? original.fileStateThreshold : configuration.getInteger(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD);
        if (sizeThreshold >= 0 && sizeThreshold <= 0x100000) {
            this.fileStateThreshold = sizeThreshold;
        } else {
            this.fileStateThreshold = (Integer)CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue();
            LoggerFactory.getLogger(AbstractFileStateBackend.class).warn("Ignoring invalid file size threshold value ({}): {} - using default value {} instead.", new Object[]{CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.key(), sizeThreshold, CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue()});
        }
    }

    @Deprecated
    public Path getBasePath() {
        return this.getCheckpointPath();
    }

    @Override
    @Nonnull
    public Path getCheckpointPath() {
        return super.getCheckpointPath();
    }

    public int getMinFileSizeThreshold() {
        return this.fileStateThreshold >= 0 ? this.fileStateThreshold : (Integer)CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue();
    }

    public boolean isUsingAsynchronousSnapshots() {
        return this.asynchronousSnapshots.getOrDefault(((Boolean)CheckpointingOptions.ASYNC_SNAPSHOTS.defaultValue()).booleanValue());
    }

    @Override
    public FsStateBackend configure(Configuration config) {
        return new FsStateBackend(this, config);
    }

    @Override
    public CheckpointStorage createCheckpointStorage(JobID jobId) throws IOException {
        Preconditions.checkNotNull((Object)jobId, (String)"jobId");
        return new FsCheckpointStorage(this.getCheckpointPath(), this.getSavepointPath(), jobId, this.getMinFileSizeThreshold());
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry) {
        TaskStateManager taskStateManager = env.getTaskStateManager();
        LocalRecoveryConfig localRecoveryConfig = taskStateManager.createLocalRecoveryConfig();
        return new HeapKeyedStateBackend<K>(kvStateRegistry, keySerializer, env.getUserClassLoader(), numberOfKeyGroups, keyGroupRange, this.isUsingAsynchronousSnapshots(), env.getExecutionConfig(), localRecoveryConfig);
    }

    @Override
    public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier) {
        return new DefaultOperatorStateBackend(env.getUserClassLoader(), env.getExecutionConfig(), this.isUsingAsynchronousSnapshots());
    }

    public String toString() {
        return "File State Backend (checkpoints: '" + this.getCheckpointPath() + "', savepoints: '" + this.getSavepointPath() + "', asynchronous: " + this.asynchronousSnapshots + ", fileStateThreshold: " + this.fileStateThreshold + ")";
    }
}

