/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.RegisteredKeyedBackendStateMetaInfo;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.runtime.state.heap.StateTableSnapshot;
import org.apache.flink.util.Preconditions;

public abstract class StateTable<K, N, S> {
    protected final InternalKeyContext<K> keyContext;
    protected RegisteredKeyedBackendStateMetaInfo<N, S> metaInfo;

    public StateTable(InternalKeyContext<K> keyContext, RegisteredKeyedBackendStateMetaInfo<N, S> metaInfo) {
        this.keyContext = (InternalKeyContext)Preconditions.checkNotNull(keyContext);
        this.metaInfo = (RegisteredKeyedBackendStateMetaInfo)Preconditions.checkNotNull(metaInfo);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    public abstract S get(N var1);

    public abstract boolean containsKey(N var1);

    public abstract void put(N var1, S var2);

    public abstract S putAndGetOld(N var1, S var2);

    public abstract void remove(N var1);

    public abstract S removeAndGetOld(N var1);

    public abstract <T> void transform(N var1, T var2, StateTransformationFunction<S, T> var3) throws Exception;

    public abstract S get(K var1, N var2);

    public abstract Stream<K> getKeys(N var1);

    public TypeSerializer<S> getStateSerializer() {
        return this.metaInfo.getStateSerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.metaInfo.getNamespaceSerializer();
    }

    public RegisteredKeyedBackendStateMetaInfo<N, S> getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(RegisteredKeyedBackendStateMetaInfo<N, S> metaInfo) {
        this.metaInfo = metaInfo;
    }

    abstract StateTableSnapshot createSnapshot();

    public abstract void put(K var1, int var2, N var3, S var4);

    @VisibleForTesting
    public abstract int sizeOfNamespace(Object var1);
}

