/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;

public class StateObjectCollection<T extends StateObject>
implements Collection<T>,
StateObject {
    private static final long serialVersionUID = 1L;
    private static final StateObjectCollection<?> EMPTY = new StateObjectCollection(Collections.emptyList());
    private final Collection<T> stateObjects;

    public StateObjectCollection() {
        this.stateObjects = new ArrayList<T>();
    }

    public StateObjectCollection(Collection<T> stateObjects) {
        this.stateObjects = stateObjects != null ? stateObjects : Collections.emptyList();
    }

    @Override
    public int size() {
        return this.stateObjects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stateObjects.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.stateObjects.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stateObjects.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.stateObjects.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.stateObjects.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.stateObjects.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.stateObjects.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.stateObjects.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.stateObjects.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.stateObjects.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.stateObjects.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.stateObjects.retainAll(c);
    }

    @Override
    public void clear() {
        this.stateObjects.clear();
    }

    @Override
    public void discardState() throws Exception {
        StateUtil.bestEffortDiscardAllStateObjects(this.stateObjects);
    }

    @Override
    public long getStateSize() {
        return StateObjectCollection.sumAllSizes(this.stateObjects);
    }

    public boolean hasState() {
        for (StateObject state : this.stateObjects) {
            if (state == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateObjectCollection that = (StateObjectCollection)o;
        return CollectionUtils.isEqualCollection(this.stateObjects, that.stateObjects);
    }

    @Override
    public int hashCode() {
        return this.stateObjects.hashCode();
    }

    public String toString() {
        return "StateObjectCollection{" + this.stateObjects + '}';
    }

    public static <T extends StateObject> StateObjectCollection<T> empty() {
        return EMPTY;
    }

    public static <T extends StateObject> StateObjectCollection<T> singleton(T stateObject) {
        return new StateObjectCollection<T>(Collections.singleton(stateObject));
    }

    private static long sumAllSizes(Collection<? extends StateObject> stateObject) {
        long size = 0L;
        for (StateObject stateObject2 : stateObject) {
            size += StateObjectCollection.getSizeNullSafe(stateObject2);
        }
        return size;
    }

    private static long getSizeNullSafe(StateObject stateObject) {
        return stateObject != null ? stateObject.getStateSize() : 0L;
    }
}

