/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.Duration;

public class FixedDelayRestartStrategy
implements RestartStrategy {
    private final int maxNumberRestartAttempts;
    private final long delayBetweenRestartAttempts;
    private int currentRestartAttempt;

    public FixedDelayRestartStrategy(int maxNumberRestartAttempts, long delayBetweenRestartAttempts) {
        Preconditions.checkArgument((maxNumberRestartAttempts >= 0 ? 1 : 0) != 0, (Object)"Maximum number of restart attempts must be positive.");
        Preconditions.checkArgument((delayBetweenRestartAttempts >= 0L ? 1 : 0) != 0, (Object)"Delay between restart attempts must be positive");
        this.maxNumberRestartAttempts = maxNumberRestartAttempts;
        this.delayBetweenRestartAttempts = delayBetweenRestartAttempts;
        this.currentRestartAttempt = 0;
    }

    public int getCurrentRestartAttempt() {
        return this.currentRestartAttempt;
    }

    @Override
    public boolean canRestart() {
        return this.currentRestartAttempt < this.maxNumberRestartAttempts;
    }

    @Override
    public void restart(final RestartCallback restarter, ScheduledExecutor executor) {
        ++this.currentRestartAttempt;
        executor.schedule(new Runnable(){

            @Override
            public void run() {
                restarter.triggerFullRecovery();
            }
        }, this.delayBetweenRestartAttempts, TimeUnit.MILLISECONDS);
    }

    public static FixedDelayRestartStrategyFactory createFactory(Configuration configuration) throws Exception {
        long delay;
        int maxAttempts = configuration.getInteger("restart-strategy.fixed-delay.attempts", 1);
        String delayString = configuration.getString(ConfigConstants.RESTART_STRATEGY_FIXED_DELAY_DELAY);
        try {
            delay = Duration.apply((String)delayString).toMillis();
        }
        catch (NumberFormatException nfe) {
            throw new Exception("Invalid config value for " + ConfigConstants.RESTART_STRATEGY_FIXED_DELAY_DELAY + ": " + delayString + ". Value must be a valid duration (such as '100 milli' or '10 s')");
        }
        return new FixedDelayRestartStrategyFactory(maxAttempts, delay);
    }

    public String toString() {
        return "FixedDelayRestartStrategy(maxNumberRestartAttempts=" + this.maxNumberRestartAttempts + ", delayBetweenRestartAttempts=" + this.delayBetweenRestartAttempts + ')';
    }

    public static class FixedDelayRestartStrategyFactory
    extends RestartStrategyFactory {
        private static final long serialVersionUID = 6642934067762271950L;
        private final int maxAttempts;
        private final long delay;

        public FixedDelayRestartStrategyFactory(int maxAttempts, long delay) {
            this.maxAttempts = maxAttempts;
            this.delay = delay;
        }

        @Override
        public RestartStrategy createRestartStrategy() {
            return new FixedDelayRestartStrategy(this.maxAttempts, this.delay);
        }
    }
}

