/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSchedulingStrategy;

public class PreviousAllocationSchedulingStrategy
extends LocationPreferenceSchedulingStrategy {
    private static final PreviousAllocationSchedulingStrategy INSTANCE = new PreviousAllocationSchedulingStrategy();

    private PreviousAllocationSchedulingStrategy() {
    }

    @Override
    @Nullable
    public <IN, OUT> OUT findMatchWithLocality(@Nonnull SlotProfile slotProfile, @Nonnull Stream<IN> candidates, @Nonnull Function<IN, SlotContext> contextExtractor, @Nonnull Predicate<IN> additionalRequirementsFilter, @Nonnull BiFunction<IN, Locality, OUT> resultProducer) {
        Collection<AllocationID> priorAllocations = slotProfile.getPriorAllocations();
        if (priorAllocations.isEmpty()) {
            return super.findMatchWithLocality(slotProfile, candidates, contextExtractor, additionalRequirementsFilter, resultProducer);
        }
        return this.findPreviousAllocation(candidates, contextExtractor, additionalRequirementsFilter, resultProducer, priorAllocations);
    }

    @Nullable
    private <IN, OUT> OUT findPreviousAllocation(@Nonnull Stream<IN> candidates, @Nonnull Function<IN, SlotContext> contextExtractor, @Nonnull Predicate<IN> additionalRequirementsFilter, @Nonnull BiFunction<IN, Locality, OUT> resultProducer, Collection<AllocationID> priorAllocations) {
        Predicate<Object> filterByAllocation = candidate -> priorAllocations.contains((Object)((SlotContext)contextExtractor.apply(candidate)).getAllocationId());
        return candidates.filter(filterByAllocation.and(additionalRequirementsFilter)).findFirst().map(result -> resultProducer.apply(result, Locality.LOCAL)).orElse(null);
    }

    public static PreviousAllocationSchedulingStrategy getInstance() {
        return INSTANCE;
    }
}

