/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.handler.FileUploads;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.util.RestConstants;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultLastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObject;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.Attribute;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.DiskFileUpload;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.HttpDataFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.apache.flink.shaded.netty4.io.netty.util.AttributeKey;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCountUtil;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = LoggerFactory.getLogger(FileUploadHandler.class);
    public static final String HTTP_ATTRIBUTE_REQUEST = "request";
    private static final AttributeKey<FileUploads> UPLOADED_FILES = AttributeKey.valueOf((String)"UPLOADED_FILES");
    private static final HttpDataFactory DATA_FACTORY = new DefaultHttpDataFactory(true);
    private final Path uploadDir;
    private HttpPostRequestDecoder currentHttpPostRequestDecoder;
    private HttpRequest currentHttpRequest;
    private byte[] currentJsonPayload;
    private Path currentUploadDir;
    private boolean currentRequestFailed = false;

    public FileUploadHandler(Path uploadDir) {
        super(true);
        DiskFileUpload.baseDirectory = uploadDir.normalize().toAbsolutePath().toString();
        this.uploadDir = Objects.requireNonNull(uploadDir);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        try {
            if (msg instanceof HttpRequest) {
                this.currentRequestFailed = false;
                HttpRequest httpRequest = (HttpRequest)msg;
                LOG.trace("Received request. URL:{} Method:{}", (Object)httpRequest.getUri(), (Object)httpRequest.getMethod());
                if (httpRequest.getMethod().equals((Object)HttpMethod.POST)) {
                    if (HttpPostRequestDecoder.isMultipart((HttpRequest)httpRequest)) {
                        LOG.trace("Initializing multipart file upload.");
                        Preconditions.checkState((this.currentHttpPostRequestDecoder == null ? 1 : 0) != 0);
                        Preconditions.checkState((this.currentHttpRequest == null ? 1 : 0) != 0);
                        Preconditions.checkState((this.currentUploadDir == null ? 1 : 0) != 0);
                        this.currentHttpPostRequestDecoder = new HttpPostRequestDecoder(DATA_FACTORY, httpRequest);
                        this.currentHttpRequest = (HttpRequest)ReferenceCountUtil.retain((Object)httpRequest);
                        this.currentUploadDir = Files.createDirectory(this.uploadDir.resolve(UUID.randomUUID().toString()), new FileAttribute[0]);
                    } else {
                        ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                    }
                } else {
                    ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                }
            } else if (msg instanceof HttpContent && this.currentHttpPostRequestDecoder != null) {
                LOG.trace("Received http content.");
                RestServerEndpoint.createUploadDir(this.uploadDir, LOG);
                HttpContent httpContent = (HttpContent)msg;
                this.currentHttpPostRequestDecoder.offer(httpContent);
                while (httpContent != LastHttpContent.EMPTY_LAST_CONTENT && this.currentHttpPostRequestDecoder.hasNext()) {
                    InterfaceHttpData data = this.currentHttpPostRequestDecoder.next();
                    if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                        DiskFileUpload fileUpload = (DiskFileUpload)data;
                        Preconditions.checkState((boolean)fileUpload.isCompleted());
                        Path dest = this.currentUploadDir.resolve(fileUpload.getFilename());
                        fileUpload.renameTo(dest.toFile());
                        LOG.trace("Upload of file {} complete.", (Object)fileUpload.getFilename());
                        continue;
                    }
                    if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                    Attribute request = (Attribute)data;
                    LOG.trace("Upload of attribute {} complete.", (Object)request.getName());
                    if (data.getName().equals(HTTP_ATTRIBUTE_REQUEST)) {
                        this.currentJsonPayload = request.get();
                        continue;
                    }
                    this.handleError(ctx, "Received unknown attribute " + data.getName() + '.', HttpResponseStatus.BAD_REQUEST, null);
                    return;
                }
                if (httpContent instanceof LastHttpContent) {
                    LOG.trace("Finalizing multipart file upload.");
                    ctx.channel().attr(UPLOADED_FILES).set((Object)new FileUploads(this.currentUploadDir));
                    if (this.currentJsonPayload != null) {
                        DefaultLastHttpContent newContent = new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])this.currentJsonPayload), false);
                        newContent.trailingHeaders().set(((LastHttpContent)httpContent).trailingHeaders());
                        this.currentHttpRequest.headers().set("Content-Length", (Object)this.currentJsonPayload.length);
                        this.currentHttpRequest.headers().set("Content-Type", (Object)RestConstants.REST_CONTENT_TYPE);
                        ctx.fireChannelRead((Object)this.currentHttpRequest);
                        ctx.fireChannelRead((Object)newContent);
                    } else {
                        this.currentHttpRequest.headers().set("Content-Length", (Object)0);
                        this.currentHttpRequest.headers().remove("Content-Type");
                        ctx.fireChannelRead((Object)this.currentHttpRequest);
                        ctx.fireChannelRead((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                    }
                    this.reset();
                }
            } else if (this.currentRequestFailed) {
                LOG.trace("Swallowing content for failed request. {}", (Object)msg);
            } else {
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        }
        catch (Exception e) {
            this.handleError(ctx, "File upload failed.", HttpResponseStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    private void handleError(ChannelHandlerContext ctx, String errorMessage, HttpResponseStatus responseStatus, @Nullable Throwable e) {
        this.currentRequestFailed = true;
        HttpRequest tmpRequest = this.currentHttpRequest;
        this.deleteUploadedFiles();
        this.reset();
        LOG.warn(errorMessage, e);
        HandlerUtils.sendErrorResponse(ctx, tmpRequest, new ErrorResponseBody(errorMessage), responseStatus, Collections.emptyMap());
        ReferenceCountUtil.release((Object)tmpRequest);
    }

    private void deleteUploadedFiles() {
        if (this.currentUploadDir != null) {
            try {
                FileUtils.deleteDirectory((File)this.currentUploadDir.toFile());
            }
            catch (IOException e) {
                LOG.warn("Could not cleanup uploaded files.", (Throwable)e);
            }
        }
    }

    private void reset() {
        try {
            this.currentHttpPostRequestDecoder.getBodyHttpDatas().clear();
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException ned) {
            LOG.debug("Error while resetting handler.", (Throwable)ned);
        }
        this.currentHttpPostRequestDecoder.destroy();
        this.currentHttpPostRequestDecoder = null;
        this.currentHttpRequest = null;
        this.currentUploadDir = null;
        this.currentJsonPayload = null;
    }

    public static FileUploads getMultipartFileUploads(ChannelHandlerContext ctx) {
        return (FileUploads)Optional.ofNullable(ctx.channel().attr(UPLOADED_FILES).getAndRemove()).orElse(FileUploads.EMPTY);
    }
}

