/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexDetailsInfo;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobVertexDetailsHandler
extends AbstractExecutionGraphHandler<JobVertexDetailsInfo, JobVertexMessageParameters>
implements JsonArchivist {
    private final MetricFetcher<? extends RestfulGateway> metricFetcher;

    public JobVertexDetailsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobVertexDetailsInfo, JobVertexMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher<? extends RestfulGateway> metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = metricFetcher;
    }

    @Override
    protected JobVertexDetailsInfo handleRequest(HandlerRequest<EmptyRequestBody, JobVertexMessageParameters> request, AccessExecutionGraph executionGraph) throws NotFoundException {
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexID = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        AccessExecutionJobVertex jobVertex = executionGraph.getJobVertex(jobVertexID);
        if (jobVertex == null) {
            throw new NotFoundException(String.format("JobVertex %s not found", new Object[]{jobVertexID}));
        }
        return JobVertexDetailsHandler.createJobVertexDetailsInfo(jobVertex, jobID, this.metricFetcher);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        Collection<? extends AccessExecutionJobVertex> vertices = graph.getAllVertices().values();
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(vertices.size());
        for (AccessExecutionJobVertex accessExecutionJobVertex : vertices) {
            JobVertexDetailsInfo json = JobVertexDetailsHandler.createJobVertexDetailsInfo(accessExecutionJobVertex, graph.getJobID(), null);
            String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
            archive.add(new ArchivedJson(path, json));
        }
        return archive;
    }

    private static JobVertexDetailsInfo createJobVertexDetailsInfo(AccessExecutionJobVertex jobVertex, JobID jobID, @Nullable MetricFetcher<?> metricFetcher) {
        ArrayList<JobVertexDetailsInfo.VertexTaskDetail> subtasks = new ArrayList<JobVertexDetailsInfo.VertexTaskDetail>();
        long now = System.currentTimeMillis();
        int num = 0;
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            long endTime;
            ExecutionState status = vertex.getExecutionState();
            TaskManagerLocation location = vertex.getCurrentAssignedResourceLocation();
            String locationString = location == null ? "(unassigned)" : location.getHostname() + ":" + location.dataPort();
            long startTime = vertex.getStateTimestamp(ExecutionState.DEPLOYING);
            if (startTime == 0L) {
                startTime = -1L;
            }
            long l = endTime = status.isTerminal() ? vertex.getStateTimestamp(status) : -1L;
            long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
            MutableIOMetrics counts = new MutableIOMetrics();
            counts.addIOMetrics(vertex.getCurrentExecutionAttempt(), metricFetcher, jobID.toString(), jobVertex.getJobVertexId().toString());
            subtasks.add(new JobVertexDetailsInfo.VertexTaskDetail(num, status, vertex.getCurrentExecutionAttempt().getAttemptNumber(), locationString, startTime, endTime, duration, new IOMetricsInfo(counts.getNumBytesInLocal() + counts.getNumBytesInRemote(), counts.isNumBytesInLocalComplete() && counts.isNumBytesInRemoteComplete(), counts.getNumBytesOut(), counts.isNumBytesOutComplete(), counts.getNumRecordsIn(), counts.isNumRecordsInComplete(), counts.getNumRecordsOut(), counts.isNumRecordsOutComplete())));
            ++num;
        }
        return new JobVertexDetailsInfo(jobVertex.getJobVertexId(), jobVertex.getName(), jobVertex.getParallelism(), now, subtasks);
    }
}

