/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class JobStoppingHandler
extends AbstractJsonRequestHandler {
    private static final String JOB_STOPPING_REST_PATH = "/jobs/:jobid/stop";
    private static final String JOB_STOPPING_YARN_REST_PATH = "/jobs/:jobid/yarn-stop";
    private final Time timeout;

    public JobStoppingHandler(Executor executor, Time timeout) {
        super(executor);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
    }

    @Override
    public String[] getPaths() {
        return new String[]{JOB_STOPPING_REST_PATH, JOB_STOPPING_YARN_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JobID jobId = new JobID(StringUtils.hexStringToByte((String)((String)pathParams.get("jobid"))));
                if (jobManagerGateway != null) {
                    jobManagerGateway.stopJob(jobId, this.timeout);
                    return "{}";
                }
                throw new Exception("No connection to the leading JobManager.");
            }
            catch (Exception e) {
                throw new CompletionException(new FlinkException("Failed to stop the job with id: " + (String)pathParams.get("jobid") + '.', (Throwable)e));
            }
        }, this.executor);
    }
}

