/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.heap.AbstractHeapState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.internal.InternalFoldingState;
import org.apache.flink.util.Preconditions;

@Deprecated
public class HeapFoldingState<K, N, T, ACC>
extends AbstractHeapState<K, N, ACC, FoldingState<T, ACC>>
implements InternalFoldingState<K, N, T, ACC> {
    private final FoldTransformation foldTransformation;

    public HeapFoldingState(StateTable<K, N, ACC> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<ACC> valueSerializer, TypeSerializer<N> namespaceSerializer, ACC defaultValue, FoldFunction<T, ACC> foldFunction) {
        super(stateTable, keySerializer, valueSerializer, namespaceSerializer, defaultValue);
        this.foldTransformation = new FoldTransformation(foldFunction);
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    @Override
    public TypeSerializer<ACC> getValueSerializer() {
        return this.valueSerializer;
    }

    public ACC get() {
        return (ACC)this.stateTable.get(this.currentNamespace);
    }

    public void add(T value) throws IOException {
        if (value == null) {
            this.clear();
            return;
        }
        try {
            this.stateTable.transform(this.currentNamespace, value, this.foldTransformation);
        }
        catch (Exception e) {
            throw new IOException("Could not add value to folding state.", e);
        }
    }

    private final class FoldTransformation
    implements StateTransformationFunction<ACC, T> {
        private final FoldFunction<T, ACC> foldFunction;

        FoldTransformation(FoldFunction<T, ACC> foldFunction) {
            this.foldFunction = (FoldFunction)Preconditions.checkNotNull(foldFunction);
        }

        @Override
        public ACC apply(ACC previousState, T value) throws Exception {
            return this.foldFunction.fold(previousState != null ? previousState : HeapFoldingState.this.getDefaultValue(), value);
        }
    }
}

