/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import akka.actor.ActorSystem;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.MemoryLogger;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.shaded.akka.org.jboss.netty.channel.ChannelException;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerRunner
implements FatalErrorHandler,
AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerRunner.class);
    private static final long FATAL_ERROR_SHUTDOWN_TIMEOUT_MS = 10000L;
    private static final int STARTUP_FAILURE_RETURN_CODE = 1;
    private static final int RUNTIME_FAILURE_RETURN_CODE = 2;
    private final Object lock = new Object();
    private final Configuration configuration;
    private final ResourceID resourceId;
    private final Time timeout;
    private final RpcService rpcService;
    private final HighAvailabilityServices highAvailabilityServices;
    private final MetricRegistryImpl metricRegistry;
    private final BlobCacheService blobCacheService;
    private final ExecutorService executor;
    private final TaskExecutor taskManager;
    private final CompletableFuture<Void> terminationFuture;
    private boolean shutdown;

    public TaskManagerRunner(Configuration configuration, ResourceID resourceId) throws Exception {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.timeout = AkkaUtils.getTimeoutAsTime(configuration);
        this.executor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("taskmanager-future"));
        this.highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, this.executor, HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION);
        this.rpcService = TaskManagerRunner.createRpcService(configuration, this.highAvailabilityServices);
        HeartbeatServices heartbeatServices = HeartbeatServices.fromConfiguration(configuration);
        this.metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(configuration));
        ActorSystem actorSystem = ((AkkaRpcService)this.rpcService).getActorSystem();
        this.metricRegistry.startQueryService(actorSystem, resourceId);
        this.blobCacheService = new BlobCacheService(configuration, this.highAvailabilityServices.createBlobStore(), null);
        this.taskManager = TaskManagerRunner.startTaskManager(this.configuration, this.resourceId, this.rpcService, this.highAvailabilityServices, heartbeatServices, this.metricRegistry, this.blobCacheService, false, this);
        this.terminationFuture = new CompletableFuture();
        this.shutdown = false;
        MemoryLogger.startIfConfigured(LOG, configuration, actorSystem);
    }

    public void start() throws Exception {
        this.taskManager.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                this.taskManager.shutDown();
                CompletableFuture<Void> taskManagerTerminationFuture = this.taskManager.getTerminationFuture();
                CompletableFuture<Void> serviceTerminationFuture = FutureUtils.composeAfterwards(taskManagerTerminationFuture, this::shutDownServices);
                serviceTerminationFuture.whenComplete((ignored, throwable) -> {
                    if (throwable != null) {
                        this.terminationFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        this.terminationFuture.complete(null);
                    }
                });
            }
        }
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> shutDownServices() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList terminationFutures = new ArrayList(3);
            Exception exception = null;
            try {
                this.blobCacheService.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
            }
            try {
                this.metricRegistry.shutdown();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            try {
                this.highAvailabilityServices.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            terminationFutures.add(this.rpcService.stopService());
            terminationFutures.add(ExecutorUtils.nonBlockingShutdown((long)this.timeout.toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.executor}));
            if (exception != null) {
                terminationFutures.add(FutureUtils.completedExceptionally(exception));
            }
            return FutureUtils.completeAll(terminationFutures);
        }
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred while executing the TaskManager. Shutting it down...", exception);
        if (ExceptionUtils.isJvmFatalOrOutOfMemoryError((Throwable)exception)) {
            this.terminateJVM();
        } else {
            this.closeAsync();
            FutureUtils.orTimeout(this.terminationFuture, 10000L, TimeUnit.MILLISECONDS);
            this.terminationFuture.whenComplete((ignored, throwable) -> this.terminateJVM());
        }
    }

    protected void terminateJVM() {
        System.exit(2);
    }

    public static void main(String[] args) throws Exception {
        EnvironmentInformation.logEnvironmentInfo(LOG, "TaskManager", args);
        SignalHandler.register(LOG);
        JvmShutdownSafeguard.installAsShutdownHook(LOG);
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            LOG.info("Maximum number of open file descriptors is {}.", (Object)maxOpenFileHandles);
        } else {
            LOG.info("Cannot determine the maximum number of open file descriptors");
        }
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        String configDir = parameterTool.get("configDir");
        final Configuration configuration = GlobalConfiguration.loadConfiguration((String)configDir);
        try {
            FileSystem.initialize((Configuration)configuration);
        }
        catch (IOException e) {
            throw new IOException("Error while setting the default filesystem scheme from configuration.", e);
        }
        SecurityUtils.install(new SecurityConfiguration(configuration));
        try {
            SecurityUtils.getInstalledContext().runSecured(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TaskManagerRunner.runTaskManager(configuration, ResourceID.generate());
                    return null;
                }
            });
        }
        catch (Throwable t) {
            LOG.error("TaskManager initialization failed.", t);
            System.exit(1);
        }
    }

    public static void runTaskManager(Configuration configuration, ResourceID resourceId) throws Exception {
        TaskManagerRunner taskManagerRunner = new TaskManagerRunner(configuration, resourceId);
        taskManagerRunner.start();
    }

    public static TaskExecutor startTaskManager(Configuration configuration, ResourceID resourceID, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, BlobCacheService blobCacheService, boolean localCommunicationOnly, FatalErrorHandler fatalErrorHandler) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)resourceID);
        Preconditions.checkNotNull((Object)rpcService);
        Preconditions.checkNotNull((Object)highAvailabilityServices);
        LOG.info("Starting TaskManager with ResourceID: {}", (Object)resourceID);
        InetAddress remoteAddress = InetAddress.getByName(rpcService.getAddress());
        TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(configuration, remoteAddress, localCommunicationOnly);
        TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID, rpcService.getExecutor(), EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag(), EnvironmentInformation.getMaxJvmHeapMemory());
        TaskManagerMetricGroup taskManagerMetricGroup = MetricUtils.instantiateTaskManagerMetricGroup(metricRegistry, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getNetworkEnvironment());
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(configuration);
        return new TaskExecutor(rpcService, taskManagerConfiguration, highAvailabilityServices, taskManagerServices, heartbeatServices, taskManagerMetricGroup, blobCacheService, fatalErrorHandler);
    }

    public static RpcService createRpcService(Configuration configuration, HighAvailabilityServices haServices) throws Exception {
        Iterator portsIterator;
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)haServices);
        String taskManagerHostname = configuration.getString("taskmanager.hostname", null);
        if (taskManagerHostname != null) {
            LOG.info("Using configured hostname/address for TaskManager: {}.", (Object)taskManagerHostname);
        } else {
            Time lookupTimeout = Time.milliseconds((long)AkkaUtils.getLookupTimeout(configuration).toMillis());
            InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(haServices.getResourceManagerLeaderRetriever(), lookupTimeout);
            taskManagerHostname = taskManagerAddress.getHostName();
            LOG.info("TaskManager will use hostname/address '{}' ({}) for communication.", (Object)taskManagerHostname, (Object)taskManagerAddress.getHostAddress());
        }
        String portRangeDefinition = configuration.getString(TaskManagerOptions.RPC_PORT);
        try {
            portsIterator = NetUtils.getPortRangeFromString((String)portRangeDefinition);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid port range definition: " + portRangeDefinition);
        }
        while (portsIterator.hasNext()) {
            try {
                return AkkaRpcServiceUtils.createRpcService(taskManagerHostname, (Integer)portsIterator.next(), configuration);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof ChannelException || cause instanceof BindException) continue;
                throw e;
            }
        }
        throw new BindException("Could not start task manager on any port in port range " + portRangeDefinition);
    }
}

