/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.UnknownHostException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.util.ConfigurationException;

public final class StandaloneUtils {
    public static StandaloneLeaderRetrievalService createLeaderRetrievalService(Configuration configuration) throws ConfigurationException, UnknownHostException {
        return StandaloneUtils.createLeaderRetrievalService(configuration, false, null);
    }

    public static StandaloneLeaderRetrievalService createLeaderRetrievalService(Configuration configuration, boolean resolveInitialHostName, String jobManagerName) throws ConfigurationException, UnknownHostException {
        Tuple2<String, Integer> hostnamePort = HighAvailabilityServicesUtils.getJobManagerAddress(configuration);
        String jobManagerAkkaUrl = AkkaRpcServiceUtils.getRpcUrl((String)hostnamePort.f0, (int)((Integer)hostnamePort.f1), jobManagerName != null ? jobManagerName : "jobmanager", resolveInitialHostName ? HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION : HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION, configuration);
        return new StandaloneLeaderRetrievalService(jobManagerAkkaUrl);
    }

    private StandaloneUtils() {
        throw new RuntimeException();
    }
}

