/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.AbstractContainerOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLStoreOverlay
extends AbstractContainerOverlay {
    private static final Logger LOG = LoggerFactory.getLogger(SSLStoreOverlay.class);
    static final Path TARGET_KEYSTORE_PATH = new Path("keystore.jks");
    static final Path TARGET_TRUSTSTORE_PATH = new Path("truststore.jks");
    final Path keystore;
    final Path truststore;

    public SSLStoreOverlay(@Nullable File keystoreFile, @Nullable File truststoreFile) {
        this.keystore = keystoreFile != null ? new Path(keystoreFile.toURI()) : null;
        this.truststore = truststoreFile != null ? new Path(truststoreFile.toURI()) : null;
    }

    @Override
    public void configure(ContainerSpecification container) throws IOException {
        if (this.keystore != null) {
            container.getArtifacts().add(ContainerSpecification.Artifact.newBuilder().setSource(this.keystore).setDest(TARGET_KEYSTORE_PATH).setCachable(false).build());
            container.getDynamicConfiguration().setString(SecurityOptions.SSL_KEYSTORE, TARGET_KEYSTORE_PATH.getPath());
        }
        if (this.truststore != null) {
            container.getArtifacts().add(ContainerSpecification.Artifact.newBuilder().setSource(this.truststore).setDest(TARGET_TRUSTSTORE_PATH).setCachable(false).build());
            container.getDynamicConfiguration().setString(SecurityOptions.SSL_TRUSTSTORE, TARGET_TRUSTSTORE_PATH.getPath());
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        File keystorePath;
        File truststorePath;

        public Builder fromEnvironment(Configuration globalConfiguration) {
            String truststore;
            String keystore = globalConfiguration.getString(SecurityOptions.SSL_KEYSTORE);
            if (keystore != null) {
                this.keystorePath = new File(keystore);
                if (!this.keystorePath.exists()) {
                    throw new IllegalStateException("Invalid configuration for " + SecurityOptions.SSL_KEYSTORE.key());
                }
            }
            if ((truststore = globalConfiguration.getString(SecurityOptions.SSL_TRUSTSTORE)) != null) {
                this.truststorePath = new File(truststore);
                if (!this.truststorePath.exists()) {
                    throw new IllegalStateException("Invalid configuration for " + SecurityOptions.SSL_TRUSTSTORE.key());
                }
            }
            return this;
        }

        public SSLStoreOverlay build() {
            return new SSLStoreOverlay(this.keystorePath, this.truststorePath);
        }
    }
}

