/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerSenderImpl;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class HeartbeatServices {
    protected final long heartbeatInterval;
    protected final long heartbeatTimeout;

    public HeartbeatServices(long heartbeatInterval, long heartbeatTimeout) {
        Preconditions.checkArgument((0L < heartbeatInterval ? 1 : 0) != 0, (Object)"The heartbeat interval must be larger than 0.");
        Preconditions.checkArgument((heartbeatInterval <= heartbeatTimeout ? 1 : 0) != 0, (Object)"The heartbeat timeout should be larger or equal than the heartbeat timeout.");
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public <I, O> HeartbeatManager<I, O> createHeartbeatManager(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor scheduledExecutor, Logger log) {
        return new HeartbeatManagerImpl<I, O>(this.heartbeatTimeout, resourceId, heartbeatListener, scheduledExecutor, scheduledExecutor, log);
    }

    public <I, O> HeartbeatManager<I, O> createHeartbeatManagerSender(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor scheduledExecutor, Logger log) {
        return new HeartbeatManagerSenderImpl<I, O>(this.heartbeatInterval, this.heartbeatTimeout, resourceId, heartbeatListener, scheduledExecutor, scheduledExecutor, log);
    }

    public static HeartbeatServices fromConfiguration(Configuration configuration) {
        long heartbeatInterval = configuration.getLong(HeartbeatManagerOptions.HEARTBEAT_INTERVAL);
        long heartbeatTimeout = configuration.getLong(HeartbeatManagerOptions.HEARTBEAT_TIMEOUT);
        return new HeartbeatServices(heartbeatInterval, heartbeatTimeout);
    }
}

