/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.JobManagerMessages$RequestRunningJobsStatus$;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster;
import org.apache.flink.runtime.state.TaskExecutorLocalStateStoresManager;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.NetUtils;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple10;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r5h\u0001B\u0001\u0003\u00015\u0011Q\u0003T8dC24E.\u001b8l\u001b&t\u0017n\u00117vgR,'O\u0003\u0002\u0004\t\u0005YQ.\u001b8jG2,8\u000f^3s\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0011\r2Lgn['j]&\u001cE.^:uKJD\u0011b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\u0006\u000e\u0002#U\u001cXM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u0007\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0013\t\u0019\u0002\u0003C\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001eG\u0005A\u0002.[4i\u0003Z\f\u0017\u000e\\1cS2LG/_*feZL7-Z:\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\"\u0011\u0001\u00055jO\"\fg/Y5mC\nLG.\u001b;z\u0013\t\u0011sD\u0001\rIS\u001eD\u0017I^1jY\u0006\u0014\u0017\u000e\\5usN+'O^5dKNL!\u0001\b\t\t\u0013\u0015\u0002!\u0011!Q\u0001\n\u0019b\u0013!E:j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[B\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t9!i\\8mK\u0006t\u0017BA\u0017\u0011\u0003Q)8/Z*j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"B!\r\u001a4iA\u0011q\u0002\u0001\u0005\u0006'9\u0002\r\u0001\u0006\u0005\u000699\u0002\r!\b\u0005\u0006K9\u0002\rA\n\u0005\u0006_\u0001!\tA\u000e\u000b\u0004c]B\u0004\"B\n6\u0001\u0004!\u0002\"B\u00176\u0001\u00041\u0003\"B\u0018\u0001\t\u0003QDCA\u0019<\u0011\u0015\u0019\u0012\b1\u0001\u0015\u0011\u0015i\u0004\u0001\"\u0011?\u0003U9WM\\3sCR,7i\u001c8gS\u001e,(/\u0019;j_:$\"\u0001F \t\u000bMa\u0004\u0019\u0001\u000b\t\u000f\u0005\u0003!\u0019!C\u0001\u0005\u0006y!n\u001c2NC:\fw-\u001a:DY\u0006\u001c8/F\u0001Da\t!U\nE\u0002F\u0011.s!a\n$\n\u0005\u001dC\u0013A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n)1\t\\1tg*\u0011q\t\u000b\t\u0003\u00196c\u0001\u0001B\u0005O\u001f\u0006\u0005\t\u0011!B\u0001+\n\u0019q\fJ\u0019\t\rA\u0003\u0001\u0015!\u0003R\u0003AQwNY'b]\u0006<WM]\"mCN\u001c\b\u0005\r\u0002S)B\u0019Q\tS*\u0011\u00051#F!\u0003(P\u0003\u0003\u0005\tQ!\u0001V#\t1\u0016\f\u0005\u0002(/&\u0011\u0001\f\u000b\u0002\b\u001d>$\b.\u001b8h!\tQV,D\u0001\\\u0015\taF!\u0001\u0006k_\nl\u0017M\\1hKJL!AX.\u0003\u0015){'-T1oC\u001e,'\u000fC\u0004a\u0001\t\u0007I\u0011A1\u0002!Q\f7o['b]\u0006<WM]\"mCN\u001cX#\u000121\u0005\r,\u0007cA#IIB\u0011A*\u001a\u0003\nM\u001e\f\t\u0011!A\u0003\u00025\u00141a\u0018\u00133\u0011\u0019A\u0007\u0001)A\u0005S\u0006\tB/Y:l\u001b\u0006t\u0017mZ3s\u00072\f7o\u001d\u00111\u0005)d\u0007cA#IWB\u0011A\n\u001c\u0003\nM\u001e\f\t\u0011!A\u0003\u00025\f\"A\u00168\u0011\u0005=\u0014X\"\u00019\u000b\u0005E$\u0011a\u0003;bg.l\u0017M\\1hKJL!a\u001d9\u0003\u0017Q\u000b7o['b]\u0006<WM\u001d\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0003QiW-\\8ss\u0006\u00138\r[5wSN$8\t\\1tgV\tq\u000f\r\u0002yuB\u0019Q\tS=\u0011\u00051SHAC>}\u0003\u0003\u0005\tQ!\u0001\u0002\u0006\t\u0019q\fJ\u001a\t\ru\u0004\u0001\u0015!\u0003\u007f\u0003UiW-\\8ss\u0006\u00138\r[5wSN$8\t\\1tg\u0002\u00024a`A\u0002!\u0011)\u0005*!\u0001\u0011\u00071\u000b\u0019\u0001\u0002\u0006|y\u0006\u0005\t\u0011!B\u0001\u0003\u000b\t2AVA\u0004!\rQ\u0016\u0011B\u0005\u0004\u0003\u0017Y&aD'f[>\u0014\u00180\u0011:dQ&4\u0018n\u001d;\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0011\u0001\u0006:fg>,(oY3NC:\fw-\u001a:DY\u0006\u001c8/\u0006\u0002\u0002\u0014A\"\u0011QCA\r!\u0011)\u0005*a\u0006\u0011\u00071\u000bI\u0002\u0002\u0007\u0002\u001c\u0005u\u0011\u0011!A\u0001\u0006\u0003\tICA\u0002`IQB\u0001\"a\b\u0001A\u0003%\u0011\u0011E\u0001\u0016e\u0016\u001cx.\u001e:dK6\u000bg.Y4fe\u000ec\u0017m]:!a\u0011\t\u0019#a\n\u0011\t\u0015C\u0015Q\u0005\t\u0004\u0019\u0006\u001dB\u0001DA\u000e\u0003;\t\t\u0011!A\u0003\u0002\u0005%\u0012c\u0001,\u0002,A\"\u0011QFA\u001e!\u0019\ty#!\u000e\u0002:5\u0011\u0011\u0011\u0007\u0006\u0004\u0003g!\u0011\u0001E2mkN$XM\u001d4sC6,wo\u001c:l\u0013\u0011\t9$!\r\u0003)\u0019c\u0017N\\6SKN|WO]2f\u001b\u0006t\u0017mZ3s!\ra\u00151\b\u0003\r\u0003{\ty$!A\u0001\u0002\u000b\u0005\u0011\u0011\t\u0002\u0004?\u0012*D\u0001DA\u000e\u0003;\t\t1!A\u0003\u0002\u0005%\u0012c\u0001,\u0002DA!\u0011QIA&\u001b\t\t9E\u0003\u0003\u0002J\u0005E\u0012!\u0002;za\u0016\u001c\u0018\u0002BA'\u0003\u000f\u0012QCU3t_V\u00148-Z%E%\u0016$(/[3wC\ndW\rC\u0004\u0002R\u0001!\t%a\u0015\u0002\u001fM$\u0018M\u001d;K_\nl\u0015M\\1hKJ$\u0002\"!\u0016\u0002f\u0005=\u0014\u0011\u0010\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0015\t7\r^8s\u0015\t\ty&\u0001\u0003bW.\f\u0017\u0002BA2\u00033\u0012\u0001\"Q2u_J\u0014VM\u001a\u0005\t\u0003O\ny\u00051\u0001\u0002j\u0005)\u0011N\u001c3fqB\u0019q%a\u001b\n\u0007\u00055\u0004FA\u0002J]RD\u0001\"!\u001d\u0002P\u0001\u0007\u00111O\u0001\u0007gf\u001cH/Z7\u0011\t\u0005]\u0013QO\u0005\u0005\u0003o\nIFA\u0006BGR|'oU=ti\u0016l\u0007\u0002CA>\u0003\u001f\u0002\r!! \u0002\u001d=\u0004HOU3ti\u0006#GM]3tgB)q%a \u0002\u0004&\u0019\u0011\u0011\u0011\u0015\u0003\r=\u0003H/[8o!\r)\u0015QQ\u0005\u0004\u0003\u000fS%AB*ue&tw\rC\u0004\u0002\f\u0002!\t%!$\u0002)M$\u0018M\u001d;SKN|WO]2f\u001b\u0006t\u0017mZ3s)\u0019\t)&a$\u0002\u0012\"A\u0011qMAE\u0001\u0004\tI\u0007\u0003\u0005\u0002r\u0005%\u0005\u0019AA:\u0011\u001d\t)\n\u0001C!\u0003/\u000b\u0001c\u001d;beR$\u0016m]6NC:\fw-\u001a:\u0015\r\u0005U\u0013\u0011TAN\u0011!\t9'a%A\u0002\u0005%\u0004\u0002CA9\u0003'\u0003\r!a\u001d\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\u0006yq-\u001a;Be\u000eD\u0017N^3Qe>\u00048\u000f\u0006\u0005\u0002$\u0006%\u0016qWA^!\u0011\t9&!*\n\t\u0005\u001d\u0016\u0011\f\u0002\u0006!J|\u0007o\u001d\u0005\t\u0003W\u000bi\n1\u0001\u0002.\u0006a\u0011M]2iSZ,7\t\\1tgB\"\u0011qVAZ!\u0011)\u0005*!-\u0011\u00071\u000b\u0019\f\u0002\u0007\u00026\u0006%\u0016\u0011!A\u0001\u0006\u0003\t)AA\u0002`IYB\u0001\"!/\u0002\u001e\u0002\u0007\u0011\u0011N\u0001\rCJ\u001c\u0007.\u001b<f\u0007>,h\u000e\u001e\u0005\t\u0003{\u000bi\n1\u0001\u0002@\u0006Q\u0011M\u001d5jm\u0016\u0004\u0016\r\u001e5\u0011\u000b\u001d\ny(!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006\u0011am\u001d\u0006\u0004\u0003\u00174\u0011\u0001B2pe\u0016LA!a4\u0002F\n!\u0001+\u0019;i\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+\f!cZ3u\u0015>\u0014W*\u00198bO\u0016\u0014\bK]8qgR!\u00131UAl\u0003G\f)/!@\u0003\b\t]!Q\u0005B\u001b\u0005\u0013\u0012iE!\u0019\u0003t\t\r%Q\u0012BO\u0005C\u0013)\fC\u0004B\u0003#\u0004\r!!71\t\u0005m\u0017q\u001c\t\u0005\u000b\"\u000bi\u000eE\u0002M\u0003?$1\"!9\u0002X\u0006\u0005\t\u0011!B\u0001+\n\u0019q\fJ\u001c\t\r]\t\t\u000e1\u0001\u0015\u0011!\t9/!5A\u0002\u0005%\u0018A\u00044viV\u0014X-\u0012=fGV$xN\u001d\t\u0005\u0003W\fI0\u0004\u0002\u0002n*!\u0011q^Ay\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003g\f)0\u0001\u0003vi&d'BAA|\u0003\u0011Q\u0017M^1\n\t\u0005m\u0018Q\u001e\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0002CA\u0000\u0003#\u0004\rA!\u0001\u0002\u0015%|W\t_3dkR|'\u000f\u0005\u0003\u0002l\n\r\u0011\u0002\u0002B\u0003\u0003[\u0014\u0001\"\u0012=fGV$xN\u001d\u0005\t\u0005\u0013\t\t\u000e1\u0001\u0003\f\u0005y\u0011N\\:uC:\u001cW-T1oC\u001e,'\u000f\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\r\u0011\t\u0002B\u0001\tS:\u001cH/\u00198dK&!!Q\u0003B\b\u0005=Ien\u001d;b]\u000e,W*\u00198bO\u0016\u0014\b\u0002\u0003B\r\u0003#\u0004\rAa\u0007\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003\u0002B\u000f\u0005Ci!Aa\b\u000b\u0007\te1,\u0003\u0003\u0003$\t}!!C*dQ\u0016$W\u000f\\3s\u0011!\u00119#!5A\u0002\t%\u0012A\u00032m_\n\u001cVM\u001d<feB!!1\u0006B\u0019\u001b\t\u0011iCC\u0002\u00030\u0011\tAA\u00197pE&!!1\u0007B\u0017\u0005)\u0011En\u001c2TKJ4XM\u001d\u0005\t\u0005o\t\t\u000e1\u0001\u0003:\u0005\u0019B.\u001b2sCJL8)Y2iK6\u000bg.Y4feB!!1\bB#\u001b\t\u0011iD\u0003\u0003\u0003@\t\u0005\u0013\u0001\u00047jEJ\f'/_2bG\",'b\u0001B\"\t\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0005\u000f\u0012iDA\fCY>\u0014G*\u001b2sCJL8)Y2iK6\u000bg.Y4fe\"A!1JAi\u0001\u0004\t)&A\u0004be\u000eD\u0017N^3\t\u0011\t=\u0013\u0011\u001ba\u0001\u0005#\naC]3ti\u0006\u0014Ho\u0015;sCR,w-\u001f$bGR|'/\u001f\t\u0005\u0005'\u0012i&\u0004\u0002\u0003V)!!q\u000bB-\u0003\u001d\u0011Xm\u001d;beRT1Aa\u0017\u0005\u00039)\u00070Z2vi&|gn\u001a:ba\"LAAa\u0018\u0003V\t1\"+Z:uCJ$8\u000b\u001e:bi\u0016<\u0017PR1di>\u0014\u0018\u0010\u0003\u0005\u0003d\u0005E\u0007\u0019\u0001B3\u0003\u001d!\u0018.\\3pkR\u0004BAa\u001a\u0003p5\u0011!\u0011\u000e\u0006\u0005\u0005W\u0012i'\u0001\u0005ekJ\fG/[8o\u0015\r\ty\u000fK\u0005\u0005\u0005c\u0012IG\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\u0011\tU\u0014\u0011\u001ba\u0001\u0005o\nQ\u0003\\3bI\u0016\u0014X\t\\3di&|gnU3sm&\u001cW\r\u0005\u0003\u0003z\t}TB\u0001B>\u0015\r\u0011i\bB\u0001\u000fY\u0016\fG-\u001a:fY\u0016\u001cG/[8o\u0013\u0011\u0011\tIa\u001f\u0003+1+\u0017\rZ3s\u000b2,7\r^5p]N+'O^5dK\"A!QQAi\u0001\u0004\u00119)\u0001\ftk\nl\u0017\u000e\u001e;fI*{'m\u0012:ba\"\u001cFo\u001c:f!\rQ&\u0011R\u0005\u0004\u0005\u0017[&AF*vE6LG\u000f^3e\u0015>\u0014wI]1qQN#xN]3\t\u0011\t=\u0015\u0011\u001ba\u0001\u0005#\u000b\u0011d\u00195fG.\u0004x.\u001b8u%\u0016\u001cwN^3ss\u001a\u000b7\r^8ssB!!1\u0013BM\u001b\t\u0011)JC\u0002\u0003\u0018\u0012\t!b\u00195fG.\u0004x.\u001b8u\u0013\u0011\u0011YJ!&\u00033\rCWmY6q_&tGOU3d_Z,'/\u001f$bGR|'/\u001f\u0005\t\u0005?\u000b\t\u000e1\u0001\u0003f\u0005\u0011\"n\u001c2SK\u000e|g/\u001a:z)&lWm\\;u\u0011!\u0011\u0019+!5A\u0002\t\u0015\u0016!\u00066pE6\u000bg.Y4fe6+GO]5d\u000fJ|W\u000f\u001d\t\u0005\u0005O\u0013\t,\u0004\u0002\u0003**!!1\u0016BW\u0003\u00199'o\\;qg*\u0019!q\u0016\u0003\u0002\u000f5,GO]5dg&!!1\u0017BU\u0005UQuNY'b]\u0006<WM]'fiJL7m\u0012:pkBD\u0001\"a\u001f\u0002R\u0002\u0007\u0011Q\u0010\u0005\b\u0005s\u0003A\u0011\u0001B^\u0003M9W\r\u001e+bg.l\u0015M\\1hKJ\u0004&o\u001c9t)Q\t\u0019K!0\u0003J\ne'1\u001dBw\u0005{\u001c)b!\n\u00046!9\u0001Ma.A\u0002\t}\u0006\u0007\u0002Ba\u0005\u000b\u0004B!\u0012%\u0003DB\u0019AJ!2\u0005\u0017\t\u001d'QXA\u0001\u0002\u0003\u0015\t!\u001c\u0002\u0004?\u0012B\u0004\u0002\u0003Bf\u0005o\u0003\rA!4\u0002#Q\f7o['b]\u0006<WM]\"p]\u001aLw\r\u0005\u0003\u0003P\nUWB\u0001Bi\u0015\r\u0011\u0019\u000eB\u0001\ri\u0006\u001c8.\u001a=fGV$xN]\u0005\u0005\u0005/\u0014\tN\u0001\rUCN\\W*\u00198bO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:D\u0001Ba7\u00038\u0002\u0007!Q\\\u0001\u000be\u0016\u001cx.\u001e:dK&#\u0005\u0003BA#\u0005?LAA!9\u0002H\tQ!+Z:pkJ\u001cW-\u0013#\t\u0011\t\u0015(q\u0017a\u0001\u0005O\f1\u0003^1tW6\u000bg.Y4fe2{7-\u0019;j_:\u00042a\u001cBu\u0013\r\u0011Y\u000f\u001d\u0002\u0014)\u0006\u001c8.T1oC\u001e,'\u000fT8dCRLwN\u001c\u0005\t\u0005_\u00149\f1\u0001\u0003r\u0006iQ.Z7pefl\u0015M\\1hKJ\u0004BAa=\u0003z6\u0011!Q\u001f\u0006\u0004\u0005o$\u0011AB7f[>\u0014\u00180\u0003\u0003\u0003|\nU(!D'f[>\u0014\u00180T1oC\u001e,'\u000f\u0003\u0005\u0003\u0000\n]\u0006\u0019AB\u0001\u0003%Iw.T1oC\u001e,'\u000f\u0005\u0003\u0004\u0004\rEQBAB\u0003\u0015\u0011\u00199a!\u0003\u0002\u0013%|W.\u00198bO\u0016\u0014(\u0002BB\u0006\u0007\u001b\tA\u0001Z5tW*\u00191q\u0002\u0003\u0002\u0005%|\u0017\u0002BB\n\u0007\u000b\u0011\u0011\"S(NC:\fw-\u001a:\t\u0011\r]!q\u0017a\u0001\u00073\t!C\\3uo>\u00148.\u00128wSJ|g.\\3oiB!11DB\u0011\u001b\t\u0019iB\u0003\u0003\u0004 \r5\u0011a\u00028fi^|'o[\u0005\u0005\u0007G\u0019iB\u0001\nOKR<xN]6F]ZL'o\u001c8nK:$\b\u0002CB\u0014\u0005o\u0003\ra!\u000b\u0002EQ\f7o['b]\u0006<WM\u001d'pG\u0006d7\u000b^1uKN#xN]3t\u001b\u0006t\u0017mZ3s!\u0011\u0019Yc!\r\u000e\u0005\r5\"bAB\u0018\t\u0005)1\u000f^1uK&!11GB\u0017\u0005\r\"\u0016m]6Fq\u0016\u001cW\u000f^8s\u0019>\u001c\u0017\r\\*uCR,7\u000b^8sKNl\u0015M\\1hKJD\u0001ba\u000e\u00038\u0002\u00071\u0011H\u0001\u0017i\u0006\u001c8.T1oC\u001e,'/T3ue&\u001cwI]8vaB!!qUB\u001e\u0013\u0011\u0019iD!+\u0003-Q\u000b7o['b]\u0006<WM]'fiJL7m\u0012:pkBDqa!\u0011\u0001\t\u0003\u0019\u0019%A\fhKR\u0014Vm]8ve\u000e,W*\u00198bO\u0016\u0014\bK]8qgRA\u00111UB#\u0007?\u001a\t\u0007\u0003\u0005\u0002\u0010\r}\u0002\u0019AB$a\u0011\u0019Ie!\u0014\u0011\t\u0015C51\n\t\u0004\u0019\u000e5C\u0001DB(\u0007\u000b\n\t\u0011!A\u0003\u0002\rE#aA0%sE\u0019aka\u00151\t\rU3\u0011\f\t\u0007\u0003_\t)da\u0016\u0011\u00071\u001bI\u0006\u0002\u0007\u0004\\\ru\u0013\u0011!A\u0001\u0006\u0003\t\tE\u0001\u0003`IE\u0002D\u0001DB(\u0007\u000b\n\t1!A\u0003\u0002\rE\u0003BB\f\u0004@\u0001\u0007A\u0003\u0003\u0005\u0004d\r}\u0002\u0019AB3\u0003YaW-\u00193feJ+GO]5fm\u0006d7+\u001a:wS\u000e,\u0007\u0003BB4\u0007[j!a!\u001b\u000b\u0007\r-D!A\bmK\u0006$WM\u001d:fiJLWM^1m\u0013\u0011\u0019yg!\u001b\u0003-1+\u0017\rZ3s%\u0016$(/[3wC2\u001cVM\u001d<jG\u0016Dqaa\u001d\u0001\t\u0003\u0019)(A\rj]&$\u0018.\u00197ju\u0016LuJR8s[\u0006$8\t\\1tg\u0016\u001cH\u0003BB<\u0007{\u00022aJB=\u0013\r\u0019Y\b\u000b\u0002\u0005+:LG\u000f\u0003\u0004\u0018\u0007c\u0002\r\u0001\u0006\u0005\b\u0007\u0003\u0003A\u0011ABB\u0003%\u0019X\r^'f[>\u0014\u0018\u0010\u0006\u0003\u0004x\r\u0015\u0005bBBD\u0007\u007f\u0002\r\u0001F\u0001\u0007G>tg-[4\t\u000f\r-\u0005\u0001\"\u0001\u0004\u000e\u0006\u0001r-\u001a;EK\u001a\fW\u000f\u001c;D_:4\u0017nZ\u000b\u0002)!91\u0011\u0013\u0001\u0005\u0012\rM\u0015!E4fi*{'-T1oC\u001e,'OT1nKR!\u00111QBK\u0011!\t9ga$A\u0002\u0005%\u0004bBBM\u0001\u0011E11T\u0001\u0017O\u0016$(+Z:pkJ\u001cW-T1oC\u001e,'OT1nKR!\u00111QBO\u0011!\t9ga&A\u0002\u0005%\u0004bBBQ\u0001\u0011E11U\u0001\u000fO\u0016$\u0018I]2iSZ,g*Y7f)\u0011\t\u0019i!*\t\u0011\u0005\u001d4q\u0014a\u0001\u0003SBqa!+\u0001\t\u0003\u0019Y+\u0001\u000bdkJ\u0014XM\u001c;msJ+hN\\5oO*{'m]\u000b\u0003\u0007[\u0003baa,\u0004@\u000e\u0015g\u0002BBY\u0007wsAaa-\u0004:6\u00111Q\u0017\u0006\u0004\u0007oc\u0011A\u0002\u001fs_>$h(C\u0001*\u0013\r\u0019i\fK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019\tma1\u0003\u0011%#XM]1cY\u0016T1a!0)!\u0011\u00199m!5\u000e\u0005\r%'\u0002BBf\u0007\u001b\faaY8n[>t'bABh\r\u0005\u0019\u0011\r]5\n\t\rM7\u0011\u001a\u0002\u0006\u0015>\u0014\u0017\n\u0012\u0005\b\u0007/\u0004A\u0011ABm\u0003m9W\r^\"veJ,g\u000e\u001e7z%Vtg.\u001b8h\u0015>\u00147OS1wCR\u001111\u001c\t\u0007\u0007;\u001cyn!2\u000e\u0005\u0005E\u0018\u0002BBq\u0003c\u0014A\u0001T5ti\"91Q\u001d\u0001\u0005\u0002\r\u001d\u0018aB:u_BTuN\u0019\u000b\u0005\u0007o\u001aI\u000f\u0003\u0005\u0004l\u000e\r\b\u0019ABc\u0003\tIG\r")
public class LocalFlinkMiniCluster
extends FlinkMiniCluster {
    private final Class<? extends JobManager> jobManagerClass = JobManager.class;
    private final Class<? extends TaskManager> taskManagerClass = TaskManager.class;
    private final Class<? extends MemoryArchivist> memoryArchivistClass = MemoryArchivist.class;
    private final Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass = StandaloneResourceManager.class;

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration generateConfiguration(Configuration userConfiguration) {
        void var2_2;
        Configuration config = this.getDefaultConfig();
        this.setDefaultCiConfig(config);
        config.addAll(userConfiguration);
        this.setMemory(config);
        this.initializeIOFormatClasses(config);
        return var2_2;
    }

    public Class<? extends JobManager> jobManagerClass() {
        return this.jobManagerClass;
    }

    public Class<? extends TaskManager> taskManagerClass() {
        return this.taskManagerClass;
    }

    public Class<? extends MemoryArchivist> memoryArchivistClass() {
        return this.memoryArchivistClass;
    }

    public Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass() {
        return this.resourceManagerClass;
    }

    @Override
    public ActorRef startJobManager(int index, ActorSystem system, Option<String> optRestAddress) {
        Tuple10<InstanceManager, Scheduler, BlobServer, BlobLibraryCacheManager, RestartStrategyFactory, FiniteDuration, Object, Option<Path>, FiniteDuration, JobManagerMetricGroup> tuple10;
        Configuration config = this.originalConfiguration().clone();
        String jobManagerName = this.getJobManagerName(index);
        String archiveName = this.getArchiveName(index);
        int jobManagerPort = config.getInteger(JobManagerOptions.PORT);
        if (jobManagerPort > 0) {
            config.setInteger(JobManagerOptions.PORT, jobManagerPort + index);
        }
        if ((tuple10 = JobManager$.MODULE$.createJobManagerComponents(config, this.futureExecutor(), this.ioExecutor(), super.highAvailabilityServices().createBlobStore(), (MetricRegistry)this.metricRegistryOpt().get())) != null) {
            Tuple10 tuple102;
            InstanceManager instanceManager = (InstanceManager)tuple10._1();
            Scheduler scheduler = (Scheduler)tuple10._2();
            BlobServer blobServer = (BlobServer)tuple10._3();
            BlobLibraryCacheManager libraryCacheManager = (BlobLibraryCacheManager)tuple10._4();
            RestartStrategyFactory restartStrategyFactory = (RestartStrategyFactory)tuple10._5();
            FiniteDuration timeout = (FiniteDuration)tuple10._6();
            int archiveCount = BoxesRunTime.unboxToInt((Object)tuple10._7());
            Option archivePath = (Option)tuple10._8();
            FiniteDuration jobRecoveryTimeout = (FiniteDuration)tuple10._9();
            JobManagerMetricGroup jobManagerMetricGroup = (JobManagerMetricGroup)tuple10._10();
            Tuple10 tuple103 = tuple102 = new Tuple10((Object)instanceManager, (Object)scheduler, (Object)blobServer, (Object)libraryCacheManager, (Object)restartStrategyFactory, (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)archivePath, (Object)jobRecoveryTimeout, (Object)jobManagerMetricGroup);
            InstanceManager instanceManager2 = (InstanceManager)tuple103._1();
            Scheduler scheduler2 = (Scheduler)tuple103._2();
            BlobServer blobServer2 = (BlobServer)tuple103._3();
            BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple103._4();
            RestartStrategyFactory restartStrategyFactory2 = (RestartStrategyFactory)tuple103._5();
            FiniteDuration timeout2 = (FiniteDuration)tuple103._6();
            int archiveCount2 = BoxesRunTime.unboxToInt((Object)tuple103._7());
            Option archivePath2 = (Option)tuple103._8();
            FiniteDuration jobRecoveryTimeout2 = (FiniteDuration)tuple103._9();
            JobManagerMetricGroup jobManagerMetricGroup2 = (JobManagerMetricGroup)tuple103._10();
            ActorRef archive = system.actorOf(this.getArchiveProps(this.memoryArchivistClass(), archiveCount2, (Option<Path>)archivePath2), archiveName);
            return system.actorOf(this.getJobManagerProps(this.jobManagerClass(), config, this.futureExecutor(), this.ioExecutor(), instanceManager2, scheduler2, blobServer2, libraryCacheManager2, archive, restartStrategyFactory2, timeout2, super.highAvailabilityServices().getJobManagerLeaderElectionService(HighAvailabilityServices.DEFAULT_JOB_ID), super.highAvailabilityServices().getSubmittedJobGraphStore(), super.highAvailabilityServices().getCheckpointRecoveryFactory(), jobRecoveryTimeout2, jobManagerMetricGroup2, optRestAddress), jobManagerName);
        }
        throw new MatchError(tuple10);
    }

    @Override
    public ActorRef startResourceManager(int index, ActorSystem system) {
        Configuration config = this.originalConfiguration().clone();
        String resourceManagerName = this.getResourceManagerName(index);
        int resourceManagerPort = config.getInteger(ResourceManagerOptions.IPC_PORT);
        if (resourceManagerPort > 0) {
            config.setInteger(ResourceManagerOptions.IPC_PORT, resourceManagerPort + index);
        }
        Props resourceManagerProps = this.getResourceManagerProps(this.resourceManagerClass(), config, super.highAvailabilityServices().getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID));
        return system.actorOf(resourceManagerProps, resourceManagerName);
    }

    @Override
    public ActorRef startTaskManager(int index, ActorSystem system) {
        Integer rpcPort;
        Configuration config = this.originalConfiguration().clone();
        String rpcPortRange = config.getString(TaskManagerOptions.RPC_PORT);
        Iterator rpcPortIterator = NetUtils.getPortRangeFromString((String)rpcPortRange);
        int dataPort = config.getInteger(TaskManagerOptions.DATA_PORT);
        if (rpcPortIterator.hasNext() && Predef$.MODULE$.Integer2int(rpcPort = (Integer)rpcPortIterator.next()) > 0) {
            config.setInteger("taskmanager.rpc.port", Predef$.MODULE$.Integer2int(rpcPort) + index);
        }
        if (dataPort > 0) {
            config.setInteger(TaskManagerOptions.DATA_PORT, dataPort + index);
        }
        boolean localExecution = this.numTaskManagers() == 1;
        String taskManagerActorName = super.useSingleActorSystem() ? new StringBuilder().append((Object)"taskmanager_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : "taskmanager";
        ResourceID resourceID = ResourceID.generate();
        InetAddress taskManagerAddress = InetAddress.getByName(this.hostname());
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(config);
        TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(config, taskManagerAddress, localExecution);
        TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID, this.ioExecutor(), EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag(), EnvironmentInformation.getMaxJvmHeapMemory());
        TaskManagerMetricGroup taskManagerMetricGroup = MetricUtils.instantiateTaskManagerMetricGroup((MetricRegistry)this.metricRegistryOpt().get(), taskManagerServices.getTaskManagerLocation(), taskManagerServices.getNetworkEnvironment());
        Props props2 = this.getTaskManagerProps(this.taskManagerClass(), taskManagerConfiguration, resourceID, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getMemoryManager(), taskManagerServices.getIOManager(), taskManagerServices.getNetworkEnvironment(), taskManagerServices.getTaskManagerStateStore(), taskManagerMetricGroup);
        return system.actorOf(props2, taskManagerActorName);
    }

    public Props getArchiveProps(Class<? extends MemoryArchivist> archiveClass, int archiveCount, Option<Path> arhivePath) {
        return JobManager$.MODULE$.getArchiveProps(archiveClass, archiveCount, (Option<Path>)Option$.MODULE$.empty());
    }

    public Props getJobManagerProps(Class<? extends JobManager> jobManagerClass, Configuration configuration, ScheduledExecutorService futureExecutor, Executor ioExecutor, InstanceManager instanceManager, Scheduler scheduler, BlobServer blobServer, BlobLibraryCacheManager libraryCacheManager, ActorRef archive, RestartStrategyFactory restartStrategyFactory, FiniteDuration timeout, LeaderElectionService leaderElectionService, SubmittedJobGraphStore submittedJobGraphStore, CheckpointRecoveryFactory checkpointRecoveryFactory, FiniteDuration jobRecoveryTimeout, JobManagerMetricGroup jobManagerMetricGroup, Option<String> optRestAddress) {
        return JobManager$.MODULE$.getJobManagerProps(jobManagerClass, configuration, futureExecutor, ioExecutor, instanceManager, scheduler, blobServer, libraryCacheManager, archive, restartStrategyFactory, timeout, leaderElectionService, submittedJobGraphStore, checkpointRecoveryFactory, jobRecoveryTimeout, jobManagerMetricGroup, optRestAddress);
    }

    public Props getTaskManagerProps(Class<? extends TaskManager> taskManagerClass, TaskManagerConfiguration taskManagerConfig, ResourceID resourceID, TaskManagerLocation taskManagerLocation, MemoryManager memoryManager, IOManager ioManager, NetworkEnvironment networkEnvironment, TaskExecutorLocalStateStoresManager taskManagerLocalStateStoresManager, TaskManagerMetricGroup taskManagerMetricGroup) {
        return TaskManager$.MODULE$.getTaskManagerProps(taskManagerClass, taskManagerConfig, resourceID, taskManagerLocation, memoryManager, ioManager, networkEnvironment, taskManagerLocalStateStoresManager, super.highAvailabilityServices(), taskManagerMetricGroup);
    }

    public Props getResourceManagerProps(Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass, Configuration configuration, LeaderRetrievalService leaderRetrievalService) {
        return FlinkResourceManager.getResourceManagerProps(resourceManagerClass, configuration, leaderRetrievalService);
    }

    public void initializeIOFormatClasses(Configuration configuration) {
        try {
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", Configuration.class);
            om.setAccessible(true);
            om.invoke(null, configuration);
        }
        catch (Exception exception) {
            this.LOG().error("Cannot (re) initialize the globally loaded defaults. Some classes might not follow the specified default behaviour.");
        }
    }

    public void setMemory(Configuration config) {
        if (config.getString(TaskManagerOptions.MANAGED_MEMORY_SIZE).equals(TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue())) {
            int numTaskManager = config.getInteger("local.number-taskmanager", 1);
            float memoryFraction = config.getFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION);
            long memorySize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            memorySize /= (long)(numTaskManager + 1);
            memorySize -= TaskManagerServices.calculateNetworkBufferMemory(memorySize, config);
            memorySize = (long)((double)memorySize * (double)memoryFraction);
            config.setString(TaskManagerOptions.MANAGED_MEMORY_SIZE, new StringBuilder().append(memorySize >>= 20).append((Object)"m").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getDefaultConfig() {
        void var1_1;
        Configuration config = new Configuration();
        config.setString(JobManagerOptions.ADDRESS, this.hostname());
        config.setInteger(JobManagerOptions.PORT, 0);
        config.setInteger("local.number-taskmanager", 1);
        config.setInteger(NettyConfig.NUM_THREADS_CLIENT, 1);
        config.setInteger(NettyConfig.NUM_THREADS_SERVER, 2);
        return var1_1;
    }

    public String getJobManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)"jobmanager_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : "jobmanager";
    }

    public String getResourceManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)"resourcemanager_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : "resourcemanager";
    }

    public String getArchiveName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)"archive_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : "archive";
    }

    public Iterable<JobID> currentlyRunningJobs() {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future future = leader.ask(JobManagerMessages$RequestRunningJobsStatus$.MODULE$, this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.RunningJobsStatus.class));
        return (Iterable)((JobManagerMessages.RunningJobsStatus)Await$.MODULE$.result((Awaitable)future, (Duration)this.timeout())).runningJobs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JobID apply(JobStatusMessage x$2) {
                return x$2.getJobId();
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public List<JobID> getCurrentlyRunningJobsJava() {
        void var1_1;
        ArrayList list = new ArrayList();
        this.currentlyRunningJobs().foreach((Function1)new Serializable(this, list){
            public static final long serialVersionUID = 0L;
            private final ArrayList list$1;

            public final boolean apply(JobID x$1) {
                return this.list$1.add(x$1);
            }
            {
                this.list$1 = list$1;
            }
        });
        return var1_1;
    }

    public void stopJob(JobID id) {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future response = leader.ask(new JobManagerMessages.StopJob(id), this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.StoppingResponse.class));
        JobManagerMessages.StoppingResponse rc = (JobManagerMessages.StoppingResponse)Await$.MODULE$.result((Awaitable)response, (Duration)this.timeout());
        JobManagerMessages.StoppingResponse stoppingResponse = rc;
        if (stoppingResponse instanceof JobManagerMessages.StoppingFailure) {
            JobManagerMessages.StoppingFailure stoppingFailure = (JobManagerMessages.StoppingFailure)stoppingResponse;
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping the job with ID ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), stoppingFailure.cause());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, HighAvailabilityServices highAvailabilityServices, boolean singleActorSystem) {
        super(userConfiguration, highAvailabilityServices, singleActorSystem);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean useSingleActorSystem) {
        this(userConfiguration, HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices(userConfiguration, (Executor)ExecutionContext$.MODULE$.global()), useSingleActorSystem);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration) {
        this(userConfiguration, true);
    }
}

