/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLEngineFactory {
    private final SSLContext sslContext;
    private final String[] enabledProtocols;
    private final String[] enabledCipherSuites;
    private final boolean clientMode;
    final boolean clientAuthentication;

    public SSLEngineFactory(SSLContext sslContext, String[] enabledProtocols, String[] enabledCipherSuites, boolean clientMode, boolean clientAuthentication) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext must not be null");
        this.enabledProtocols = Objects.requireNonNull(enabledProtocols, "enabledProtocols must not be null");
        this.enabledCipherSuites = Objects.requireNonNull(enabledCipherSuites, "cipherSuites must not be null");
        this.clientMode = clientMode;
        this.clientAuthentication = clientAuthentication;
    }

    public SSLEngine createSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        this.configureSSLEngine(sslEngine);
        return sslEngine;
    }

    public SSLEngine createSSLEngine(String hostname, int port) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(hostname, port);
        this.configureSSLEngine(sslEngine);
        return sslEngine;
    }

    private void configureSSLEngine(SSLEngine sslEngine) {
        sslEngine.setEnabledProtocols(this.enabledProtocols);
        sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        sslEngine.setUseClientMode(this.clientMode);
        if (!this.clientMode) {
            sslEngine.setNeedClientAuth(this.clientAuthentication);
        }
    }
}

