/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rest.AbstractHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

@ChannelHandler.Sharable
public abstract class AbstractRestHandler<T extends RestfulGateway, R extends RequestBody, P extends ResponseBody, M extends MessageParameters>
extends AbstractHandler<T, R, M> {
    private final MessageHeaders<R, P, M> messageHeaders;

    protected AbstractRestHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends T> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<R, P, M> messageHeaders) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.messageHeaders = (MessageHeaders)Preconditions.checkNotNull(messageHeaders);
    }

    public MessageHeaders<R, P, M> getMessageHeaders() {
        return this.messageHeaders;
    }

    @Override
    protected CompletableFuture<Void> respondToRequest(ChannelHandlerContext ctx, HttpRequest httpRequest, HandlerRequest<R, M> handlerRequest, T gateway) {
        CompletableFuture<Object> response;
        try {
            response = this.handleRequest(handlerRequest, gateway);
        }
        catch (RestHandlerException e) {
            response = FutureUtils.completedExceptionally((Throwable)((Object)e));
        }
        return ((CompletableFuture)response.whenComplete((resp, throwable) -> {
            Tuple2 r = throwable != null ? this.errorResponse((Throwable)throwable) : Tuple2.of((Object)resp, (Object)this.messageHeaders.getResponseStatusCode());
            HandlerUtils.sendResponse(ctx, httpRequest, (ResponseBody)r.f0, (HttpResponseStatus)r.f1, (Map<String, String>)this.responseHeaders);
        })).thenApply(ignored -> null);
    }

    private Tuple2<ResponseBody, HttpResponseStatus> errorResponse(Throwable throwable) {
        Throwable error = ExceptionUtils.stripCompletionException((Throwable)throwable);
        if (error instanceof RestHandlerException) {
            RestHandlerException rhe = (RestHandlerException)((Object)error);
            this.log.error("Exception occurred in REST handler.", (Throwable)((Object)rhe));
            return Tuple2.of((Object)new ErrorResponseBody(rhe.getMessage()), (Object)rhe.getHttpResponseStatus());
        }
        this.log.error("Implementation error: Unhandled exception.", error);
        String stackTrace = String.format("<Exception on server side:%n%s%nEnd of exception on server side>", ExceptionUtils.stringifyException((Throwable)throwable));
        return Tuple2.of((Object)new ErrorResponseBody(Arrays.asList("Internal server error.", stackTrace)), (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    protected abstract CompletableFuture<P> handleRequest(@Nonnull HandlerRequest<R, M> var1, @Nonnull T var2) throws RestHandlerException;
}

