/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.rest.handler.router.RouteResult;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringDecoder;

public class RouterHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final String ROUTER_HANDLER_NAME = RouterHandler.class.getName() + "_ROUTER_HANDLER";
    private static final String ROUTED_HANDLER_NAME = RouterHandler.class.getName() + "_ROUTED_HANDLER";
    private final Map<String, String> responseHeaders;
    private final Router router;

    public RouterHandler(Router router, Map<String, String> responseHeaders) {
        this.router = Objects.requireNonNull(router);
        this.responseHeaders = Objects.requireNonNull(responseHeaders);
    }

    public String getName() {
        return ROUTER_HANDLER_NAME;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        QueryStringDecoder qsd;
        if (HttpHeaders.is100ContinueExpected((HttpMessage)httpRequest)) {
            channelHandlerContext.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            return;
        }
        HttpMethod method = httpRequest.getMethod();
        RouteResult routeResult = this.router.route(method, (qsd = new QueryStringDecoder(httpRequest.uri())).path(), qsd.parameters());
        if (routeResult == null) {
            this.respondNotFound(channelHandlerContext, httpRequest);
            return;
        }
        this.routed(channelHandlerContext, routeResult, httpRequest);
    }

    private void routed(ChannelHandlerContext channelHandlerContext, RouteResult<?> routeResult, HttpRequest httpRequest) {
        ChannelPipeline pipeline;
        ChannelHandler addedHandler;
        ChannelInboundHandler handler = (ChannelInboundHandler)routeResult.target();
        if (handler != (addedHandler = (pipeline = channelHandlerContext.pipeline()).get(ROUTED_HANDLER_NAME))) {
            if (addedHandler == null) {
                pipeline.addAfter(ROUTER_HANDLER_NAME, ROUTED_HANDLER_NAME, (ChannelHandler)handler);
            } else {
                pipeline.replace(addedHandler, ROUTED_HANDLER_NAME, (ChannelHandler)handler);
            }
        }
        RoutedRequest request = new RoutedRequest(routeResult, httpRequest);
        channelHandlerContext.fireChannelRead((Object)request.retain());
    }

    private void respondNotFound(ChannelHandlerContext channelHandlerContext, HttpRequest request) {
        HandlerUtils.sendErrorResponse(channelHandlerContext, request, new ErrorResponseBody("Not found."), HttpResponseStatus.NOT_FOUND, this.responseHeaders);
    }
}

