/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class DashboardConfiguration
implements ResponseBody {
    public static final String FIELD_NAME_REFRESH_INTERVAL = "refresh-interval";
    public static final String FIELD_NAME_TIMEZONE_OFFSET = "timezone-offset";
    public static final String FIELD_NAME_TIMEZONE_NAME = "timezone-name";
    public static final String FIELD_NAME_FLINK_VERSION = "flink-version";
    public static final String FIELD_NAME_FLINK_REVISION = "flink-revision";
    @JsonProperty(value="refresh-interval")
    private final long refreshInterval;
    @JsonProperty(value="timezone-name")
    private final String timeZoneName;
    @JsonProperty(value="timezone-offset")
    private final int timeZoneOffset;
    @JsonProperty(value="flink-version")
    private final String flinkVersion;
    @JsonProperty(value="flink-revision")
    private final String flinkRevision;

    @JsonCreator
    public DashboardConfiguration(@JsonProperty(value="refresh-interval") long refreshInterval, @JsonProperty(value="timezone-name") String timeZoneName, @JsonProperty(value="timezone-offset") int timeZoneOffset, @JsonProperty(value="flink-version") String flinkVersion, @JsonProperty(value="flink-revision") String flinkRevision) {
        this.refreshInterval = refreshInterval;
        this.timeZoneName = (String)Preconditions.checkNotNull((Object)timeZoneName);
        this.timeZoneOffset = timeZoneOffset;
        this.flinkVersion = (String)Preconditions.checkNotNull((Object)flinkVersion);
        this.flinkRevision = (String)Preconditions.checkNotNull((Object)flinkRevision);
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public String getFlinkVersion() {
        return this.flinkVersion;
    }

    public String getFlinkRevision() {
        return this.flinkRevision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardConfiguration that = (DashboardConfiguration)o;
        return this.refreshInterval == that.refreshInterval && this.timeZoneOffset == that.timeZoneOffset && Objects.equals(this.timeZoneName, that.timeZoneName) && Objects.equals(this.flinkVersion, that.flinkVersion) && Objects.equals(this.flinkRevision, that.flinkRevision);
    }

    public int hashCode() {
        return Objects.hash(this.refreshInterval, this.timeZoneName, this.timeZoneOffset, this.flinkVersion, this.flinkRevision);
    }

    public static DashboardConfiguration from(long refreshInterval, ZonedDateTime zonedDateTime) {
        String flinkVersion = EnvironmentInformation.getVersion();
        EnvironmentInformation.RevisionInformation revision = EnvironmentInformation.getRevisionInformation();
        String flinkRevision = revision != null ? revision.commitId + " @ " + revision.commitDate : "unknown revision";
        return new DashboardConfiguration(refreshInterval, zonedDateTime.getZone().getDisplayName(TextStyle.FULL, Locale.getDefault()), zonedDateTime.toOffsetDateTime().getOffset().getTotalSeconds() * 1000, flinkVersion, flinkRevision);
    }
}

