/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StateMigrationException;

public class RegisteredKeyValueStateBackendMetaInfo<N, S>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final StateDescriptor.Type stateType;
    @Nonnull
    private final TypeSerializer<N> namespaceSerializer;
    @Nonnull
    private final TypeSerializer<S> stateSerializer;
    @Nullable
    private final StateSnapshotTransformer<S> snapshotTransformer;

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateDescriptor.Type stateType, @Nonnull String name, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer) {
        this(stateType, name, namespaceSerializer, stateSerializer, null);
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateDescriptor.Type stateType, @Nonnull String name, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer, @Nullable StateSnapshotTransformer<S> snapshotTransformer) {
        super(name);
        this.stateType = stateType;
        this.namespaceSerializer = namespaceSerializer;
        this.stateSerializer = stateSerializer;
        this.snapshotTransformer = snapshotTransformer;
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(StateDescriptor.Type.valueOf((String)snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE)), snapshot.getName(), (TypeSerializer)Preconditions.checkNotNull(snapshot.getTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER)), (TypeSerializer)Preconditions.checkNotNull(snapshot.getTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER)), null);
        Preconditions.checkState((StateMetaInfoSnapshot.BackendStateType.KEY_VALUE == snapshot.getBackendStateType() ? 1 : 0) != 0);
    }

    @Nonnull
    public StateDescriptor.Type getStateType() {
        return this.stateType;
    }

    @Nonnull
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    @Nonnull
    public TypeSerializer<S> getStateSerializer() {
        return this.stateSerializer;
    }

    @Nullable
    public StateSnapshotTransformer<S> getSnapshotTransformer() {
        return this.snapshotTransformer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredKeyValueStateBackendMetaInfo that = (RegisteredKeyValueStateBackendMetaInfo)o;
        if (!this.stateType.equals((Object)that.stateType)) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getStateSerializer().equals(that.getStateSerializer()) && this.getNamespaceSerializer().equals(that.getNamespaceSerializer());
    }

    public String toString() {
        return "RegisteredKeyedBackendStateMetaInfo{stateType=" + this.stateType + ", name='" + this.name + '\'' + ", namespaceSerializer=" + this.namespaceSerializer + ", stateSerializer=" + this.stateSerializer + '}';
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getNamespaceSerializer().hashCode();
        result = 31 * result + this.getStateSerializer().hashCode();
        return result;
    }

    @Nonnull
    public static <N, S> RegisteredKeyValueStateBackendMetaInfo<N, S> resolveKvStateCompatibility(StateMetaInfoSnapshot restoredStateMetaInfoSnapshot, TypeSerializer<N> newNamespaceSerializer, StateDescriptor<?, S> newStateDescriptor, @Nullable StateSnapshotTransformer<S> snapshotTransformer) throws StateMigrationException {
        Preconditions.checkState((restoredStateMetaInfoSnapshot.getBackendStateType() == StateMetaInfoSnapshot.BackendStateType.KEY_VALUE ? 1 : 0) != 0, (Object)("Incompatible state types. Was [" + (Object)((Object)restoredStateMetaInfoSnapshot.getBackendStateType()) + "], registered as [" + (Object)((Object)StateMetaInfoSnapshot.BackendStateType.KEY_VALUE) + "]."));
        Preconditions.checkState((boolean)Objects.equals(newStateDescriptor.getName(), restoredStateMetaInfoSnapshot.getName()), (Object)("Incompatible state names. Was [" + restoredStateMetaInfoSnapshot.getName() + "], registered with [" + newStateDescriptor.getName() + "]."));
        StateDescriptor.Type restoredType = StateDescriptor.Type.valueOf((String)restoredStateMetaInfoSnapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE));
        if (!Objects.equals(newStateDescriptor.getType(), StateDescriptor.Type.UNKNOWN) && !Objects.equals(restoredType, StateDescriptor.Type.UNKNOWN)) {
            Preconditions.checkState((newStateDescriptor.getType() == restoredType ? 1 : 0) != 0, (Object)("Incompatible key/value state types. Was [" + restoredType + "], registered with [" + newStateDescriptor.getType() + "]."));
        }
        CompatibilityResult namespaceCompatibility = CompatibilityUtil.resolveCompatibilityResult(restoredStateMetaInfoSnapshot.getTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER), null, (TypeSerializerConfigSnapshot)restoredStateMetaInfoSnapshot.getTypeSerializerConfigSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER), newNamespaceSerializer);
        TypeSerializer newStateSerializer = newStateDescriptor.getSerializer();
        CompatibilityResult stateCompatibility = CompatibilityUtil.resolveCompatibilityResult(restoredStateMetaInfoSnapshot.getTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)restoredStateMetaInfoSnapshot.getTypeSerializerConfigSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER), (TypeSerializer)newStateSerializer);
        if (namespaceCompatibility.isRequiresMigration() || stateCompatibility.isRequiresMigration()) {
            throw StateMigrationException.notSupported();
        }
        return new RegisteredKeyValueStateBackendMetaInfo<N, S>(newStateDescriptor.getType(), newStateDescriptor.getName(), newNamespaceSerializer, newStateSerializer, snapshotTransformer);
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE.toString(), this.stateType.toString());
        HashMap serializerMap = new HashMap(2);
        HashMap<String, TypeSerializerConfigSnapshot> serializerConfigSnapshotsMap = new HashMap<String, TypeSerializerConfigSnapshot>(2);
        String namespaceSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER.toString();
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        serializerMap.put(namespaceSerializerKey, this.namespaceSerializer.duplicate());
        serializerConfigSnapshotsMap.put(namespaceSerializerKey, this.namespaceSerializer.snapshotConfiguration());
        serializerMap.put(valueSerializerKey, this.stateSerializer.duplicate());
        serializerConfigSnapshotsMap.put(valueSerializerKey, this.stateSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.KEY_VALUE, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }
}

