/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorDeActivator;
import org.apache.flink.runtime.checkpoint.CheckpointDeclineReason;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointTriggerException;
import org.apache.flink.runtime.checkpoint.CheckpointTriggerResult;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.checkpoint.StateAssignmentOperation;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineException;
import org.apache.flink.runtime.checkpoint.hooks.MasterHooks;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.taskmanager.DispatcherThreadFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private static final int NUM_GHOST_CHECKPOINT_IDS = 16;
    private final Object lock = new Object();
    private final Object triggerLock = new Object();
    private final JobID job;
    private final CheckpointProperties checkpointProperties;
    private final Executor executor;
    private final ExecutionVertex[] tasksToTrigger;
    private final ExecutionVertex[] tasksToWaitFor;
    private final ExecutionVertex[] tasksToCommitTo;
    private final Map<Long, PendingCheckpoint> pendingCheckpoints;
    private final CompletedCheckpointStore completedCheckpointStore;
    private final CheckpointStorage checkpointStorage;
    private final ArrayDeque<Long> recentPendingCheckpoints;
    private final CheckpointIDCounter checkpointIdCounter;
    private final long baseInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpointsNanos;
    private final int maxConcurrentCheckpointAttempts;
    private final ScheduledThreadPoolExecutor timer;
    private final HashMap<String, MasterTriggerRestoreHook<?>> masterHooks;
    private JobStatusListener jobStatusListener;
    private final AtomicInteger numUnsuccessfulCheckpointsTriggers = new AtomicInteger(0);
    private ScheduledFuture<?> currentPeriodicTrigger;
    private long lastCheckpointCompletionNanos;
    private boolean periodicScheduling;
    private boolean triggerRequestQueued;
    private volatile boolean shutdown;
    @Nullable
    private CheckpointStatsTracker statsTracker;
    private final SharedStateRegistryFactory sharedStateRegistryFactory;
    private SharedStateRegistry sharedStateRegistry;

    public CheckpointCoordinator(JobID job, long baseInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpointAttempts, CheckpointRetentionPolicy retentionPolicy, ExecutionVertex[] tasksToTrigger, ExecutionVertex[] tasksToWaitFor, ExecutionVertex[] tasksToCommitTo, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore completedCheckpointStore, StateBackend checkpointStateBackend, Executor executor, SharedStateRegistryFactory sharedStateRegistryFactory) {
        Preconditions.checkNotNull((Object)checkpointStateBackend);
        Preconditions.checkArgument((baseInterval > 0L ? 1 : 0) != 0, (Object)"Checkpoint base interval must be larger than zero");
        Preconditions.checkArgument((checkpointTimeout >= 1L ? 1 : 0) != 0, (Object)"Checkpoint timeout must be larger than zero");
        Preconditions.checkArgument((minPauseBetweenCheckpoints >= 0L ? 1 : 0) != 0, (Object)"minPauseBetweenCheckpoints must be >= 0");
        Preconditions.checkArgument((maxConcurrentCheckpointAttempts >= 1 ? 1 : 0) != 0, (Object)"maxConcurrentCheckpointAttempts must be >= 1");
        if (minPauseBetweenCheckpoints > 31536000000L) {
            minPauseBetweenCheckpoints = 31536000000L;
        }
        if (baseInterval < minPauseBetweenCheckpoints) {
            baseInterval = minPauseBetweenCheckpoints;
        }
        this.job = (JobID)Preconditions.checkNotNull((Object)job);
        this.baseInterval = baseInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpointsNanos = minPauseBetweenCheckpoints * 1000000L;
        this.maxConcurrentCheckpointAttempts = maxConcurrentCheckpointAttempts;
        this.tasksToTrigger = (ExecutionVertex[])Preconditions.checkNotNull((Object)tasksToTrigger);
        this.tasksToWaitFor = (ExecutionVertex[])Preconditions.checkNotNull((Object)tasksToWaitFor);
        this.tasksToCommitTo = (ExecutionVertex[])Preconditions.checkNotNull((Object)tasksToCommitTo);
        this.pendingCheckpoints = new LinkedHashMap<Long, PendingCheckpoint>();
        this.checkpointIdCounter = (CheckpointIDCounter)Preconditions.checkNotNull((Object)checkpointIDCounter);
        this.completedCheckpointStore = (CompletedCheckpointStore)Preconditions.checkNotNull((Object)completedCheckpointStore);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.sharedStateRegistryFactory = (SharedStateRegistryFactory)Preconditions.checkNotNull((Object)sharedStateRegistryFactory);
        this.sharedStateRegistry = sharedStateRegistryFactory.create(executor);
        this.recentPendingCheckpoints = new ArrayDeque(16);
        this.masterHooks = new HashMap();
        this.timer = new ScheduledThreadPoolExecutor(1, new DispatcherThreadFactory(Thread.currentThread().getThreadGroup(), "Checkpoint Timer"));
        this.timer.setRemoveOnCancelPolicy(true);
        this.timer.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.timer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.checkpointProperties = CheckpointProperties.forCheckpoint(retentionPolicy);
        try {
            this.checkpointStorage = checkpointStateBackend.createCheckpointStorage(job);
            checkpointIDCounter.start();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to start checkpoint ID counter: " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMasterHook(MasterTriggerRestoreHook<?> hook) {
        Preconditions.checkNotNull(hook);
        String id = hook.getIdentifier();
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)id) ? 1 : 0) != 0, (Object)"The hook has a null or empty id");
        Object object = this.lock;
        synchronized (object) {
            if (!this.masterHooks.containsKey(id)) {
                this.masterHooks.put(id, hook);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRegisteredMasterHooks() {
        Object object = this.lock;
        synchronized (object) {
            return this.masterHooks.size();
        }
    }

    public void setCheckpointStatsTracker(@Nullable CheckpointStatsTracker statsTracker) {
        this.statsTracker = statsTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(JobStatus jobStatus) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                LOG.info("Stopping checkpoint coordinator for job {}.", (Object)this.job);
                this.periodicScheduling = false;
                this.triggerRequestQueued = false;
                MasterHooks.close(this.masterHooks.values(), LOG);
                this.masterHooks.clear();
                this.timer.shutdownNow();
                for (PendingCheckpoint pending : this.pendingCheckpoints.values()) {
                    pending.abortError(new Exception("Checkpoint Coordinator is shutting down"));
                }
                this.pendingCheckpoints.clear();
                this.completedCheckpointStore.shutdown(jobStatus);
                this.checkpointIdCounter.shutdown(jobStatus);
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public CompletableFuture<CompletedCheckpoint> triggerSavepoint(long timestamp, @Nullable String targetLocation) {
        CheckpointProperties props2 = CheckpointProperties.forSavepoint();
        CheckpointTriggerResult triggerResult = this.triggerCheckpoint(timestamp, props2, targetLocation, false);
        if (triggerResult.isSuccess()) {
            return triggerResult.getPendingCheckpoint().getCompletionFuture();
        }
        CheckpointTriggerException cause = new CheckpointTriggerException("Failed to trigger savepoint.", triggerResult.getFailureReason());
        return FutureUtils.completedExceptionally((Throwable)((Object)cause));
    }

    public boolean triggerCheckpoint(long timestamp, boolean isPeriodic) {
        return this.triggerCheckpoint(timestamp, this.checkpointProperties, null, isPeriodic).isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public CheckpointTriggerResult triggerCheckpoint(long timestamp, CheckpointProperties props2, @Nullable String externalSavepointLocation, boolean isPeriodic) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return new CheckpointTriggerResult(CheckpointDeclineReason.COORDINATOR_SHUTDOWN);
            }
            if (isPeriodic && !this.periodicScheduling) {
                return new CheckpointTriggerResult(CheckpointDeclineReason.PERIODIC_SCHEDULER_SHUTDOWN);
            }
            if (!props2.forceCheckpoint()) {
                if (this.triggerRequestQueued) {
                    LOG.warn("Trying to trigger another checkpoint for job {} while one was queued already.", (Object)this.job);
                    return new CheckpointTriggerResult(CheckpointDeclineReason.ALREADY_QUEUED);
                }
                if (this.pendingCheckpoints.size() >= this.maxConcurrentCheckpointAttempts) {
                    this.triggerRequestQueued = true;
                    if (this.currentPeriodicTrigger != null) {
                        this.currentPeriodicTrigger.cancel(false);
                        this.currentPeriodicTrigger = null;
                    }
                    return new CheckpointTriggerResult(CheckpointDeclineReason.TOO_MANY_CONCURRENT_CHECKPOINTS);
                }
                long earliestNext = this.lastCheckpointCompletionNanos + this.minPauseBetweenCheckpointsNanos;
                long durationTillNextMillis = (earliestNext - System.nanoTime()) / 1000000L;
                if (durationTillNextMillis > 0L) {
                    if (this.currentPeriodicTrigger != null) {
                        this.currentPeriodicTrigger.cancel(false);
                        this.currentPeriodicTrigger = null;
                    }
                    this.currentPeriodicTrigger = this.timer.scheduleAtFixedRate(new ScheduledTrigger(), durationTillNextMillis, this.baseInterval, TimeUnit.MILLISECONDS);
                    return new CheckpointTriggerResult(CheckpointDeclineReason.MINIMUM_TIME_BETWEEN_CHECKPOINTS);
                }
            }
        }
        Execution[] executions = new Execution[this.tasksToTrigger.length];
        for (int i = 0; i < this.tasksToTrigger.length; ++i) {
            Execution object2 = this.tasksToTrigger[i].getCurrentExecutionAttempt();
            if (object2 == null) {
                LOG.info("Checkpoint triggering task {} of job {} is not being executed at the moment. Aborting checkpoint.", (Object)this.tasksToTrigger[i].getTaskNameWithSubtaskIndex(), (Object)this.job);
                return new CheckpointTriggerResult(CheckpointDeclineReason.NOT_ALL_REQUIRED_TASKS_RUNNING);
            }
            if (object2.getState() != ExecutionState.RUNNING) {
                LOG.info("Checkpoint triggering task {} of job {} is not in state {} but {} instead. Aborting checkpoint.", new Object[]{this.tasksToTrigger[i].getTaskNameWithSubtaskIndex(), this.job, ExecutionState.RUNNING, object2.getState()});
                return new CheckpointTriggerResult(CheckpointDeclineReason.NOT_ALL_REQUIRED_TASKS_RUNNING);
            }
            executions[i] = object2;
        }
        HashMap<ExecutionAttemptID, ExecutionVertex> ackTasks = new HashMap<ExecutionAttemptID, ExecutionVertex>(this.tasksToWaitFor.length);
        for (ExecutionVertex ev : this.tasksToWaitFor) {
            Execution ee = ev.getCurrentExecutionAttempt();
            if (ee == null) {
                LOG.info("Checkpoint acknowledging task {} of job {} is not being executed at the moment. Aborting checkpoint.", (Object)ev.getTaskNameWithSubtaskIndex(), (Object)this.job);
                return new CheckpointTriggerResult(CheckpointDeclineReason.NOT_ALL_REQUIRED_TASKS_RUNNING);
            }
            ackTasks.put(ee.getAttemptId(), ev);
        }
        Object object2 = this.triggerLock;
        synchronized (object2) {
            CheckpointStorageLocation checkpointStorageLocation;
            long checkpointID;
            try {
                checkpointID = this.checkpointIdCounter.getAndIncrement();
                checkpointStorageLocation = props2.isSavepoint() ? this.checkpointStorage.initializeLocationForSavepoint(checkpointID, externalSavepointLocation) : this.checkpointStorage.initializeLocationForCheckpoint(checkpointID);
            }
            catch (Throwable t) {
                int numUnsuccessful = this.numUnsuccessfulCheckpointsTriggers.incrementAndGet();
                LOG.warn("Failed to trigger checkpoint for job {} ({} consecutive failed attempts so far).", new Object[]{this.job, numUnsuccessful, t});
                return new CheckpointTriggerResult(CheckpointDeclineReason.EXCEPTION);
            }
            PendingCheckpoint checkpoint = new PendingCheckpoint(this.job, checkpointID, timestamp, ackTasks, props2, checkpointStorageLocation, this.executor);
            if (this.statsTracker != null) {
                PendingCheckpointStats callback = this.statsTracker.reportPendingCheckpoint(checkpointID, timestamp, props2);
                checkpoint.setStatsCallback(callback);
            }
            Runnable canceller = () -> {
                Object object = this.lock;
                synchronized (object) {
                    if (!checkpoint.isDiscarded()) {
                        LOG.info("Checkpoint {} of job {} expired before completing.", (Object)checkpointID, (Object)this.job);
                        checkpoint.abortExpired();
                        this.pendingCheckpoints.remove(checkpointID);
                        this.rememberRecentCheckpointId(checkpointID);
                        this.triggerQueuedRequests();
                    }
                }
            };
            try {
                Object object3 = this.lock;
                synchronized (object3) {
                    if (this.shutdown) {
                        return new CheckpointTriggerResult(CheckpointDeclineReason.COORDINATOR_SHUTDOWN);
                    }
                    if (!props2.forceCheckpoint()) {
                        if (this.triggerRequestQueued) {
                            LOG.warn("Trying to trigger another checkpoint for job {} while one was queued already.", (Object)this.job);
                            return new CheckpointTriggerResult(CheckpointDeclineReason.ALREADY_QUEUED);
                        }
                        if (this.pendingCheckpoints.size() >= this.maxConcurrentCheckpointAttempts) {
                            this.triggerRequestQueued = true;
                            if (this.currentPeriodicTrigger != null) {
                                this.currentPeriodicTrigger.cancel(false);
                                this.currentPeriodicTrigger = null;
                            }
                            return new CheckpointTriggerResult(CheckpointDeclineReason.TOO_MANY_CONCURRENT_CHECKPOINTS);
                        }
                        long earliestNext = this.lastCheckpointCompletionNanos + this.minPauseBetweenCheckpointsNanos;
                        long durationTillNextMillis = (earliestNext - System.nanoTime()) / 1000000L;
                        if (durationTillNextMillis > 0L) {
                            if (this.currentPeriodicTrigger != null) {
                                this.currentPeriodicTrigger.cancel(false);
                                this.currentPeriodicTrigger = null;
                            }
                            this.currentPeriodicTrigger = this.timer.scheduleAtFixedRate(new ScheduledTrigger(), durationTillNextMillis, this.baseInterval, TimeUnit.MILLISECONDS);
                            return new CheckpointTriggerResult(CheckpointDeclineReason.MINIMUM_TIME_BETWEEN_CHECKPOINTS);
                        }
                    }
                    LOG.info("Triggering checkpoint {} @ {} for job {}.", new Object[]{checkpointID, timestamp, this.job});
                    this.pendingCheckpoints.put(checkpointID, checkpoint);
                    Execution[] cancellerHandle = this.timer.schedule(canceller, this.checkpointTimeout, TimeUnit.MILLISECONDS);
                    if (!checkpoint.setCancellerHandle((ScheduledFuture<?>)cancellerHandle)) {
                        cancellerHandle.cancel(false);
                    }
                    List<MasterState> masterStates = MasterHooks.triggerMasterHooks(this.masterHooks.values(), checkpointID, timestamp, this.executor, Time.milliseconds((long)this.checkpointTimeout));
                    for (MasterState s : masterStates) {
                        checkpoint.addMasterState(s);
                    }
                }
                CheckpointOptions checkpointOptions = new CheckpointOptions(props2.getCheckpointType(), checkpointStorageLocation.getLocationReference());
                for (Execution execution : executions) {
                    execution.triggerCheckpoint(checkpointID, timestamp, checkpointOptions);
                }
                this.numUnsuccessfulCheckpointsTriggers.set(0);
                return new CheckpointTriggerResult(checkpoint);
            }
            catch (Throwable t) {
                Object cancellerHandle = this.lock;
                synchronized (cancellerHandle) {
                    this.pendingCheckpoints.remove(checkpointID);
                }
                int numUnsuccessful = this.numUnsuccessfulCheckpointsTriggers.incrementAndGet();
                LOG.warn("Failed to trigger checkpoint {} for job {}. ({} consecutive failed attempts so far)", new Object[]{checkpointID, this.job, numUnsuccessful, t});
                if (!checkpoint.isDiscarded()) {
                    checkpoint.abortError(new Exception("Failed to trigger checkpoint", t));
                }
                try {
                    checkpointStorageLocation.disposeOnFailure();
                }
                catch (Throwable t2) {
                    LOG.warn("Cannot dispose failed checkpoint storage location {}", (Object)checkpointStorageLocation, (Object)t2);
                }
                return new CheckpointTriggerResult(CheckpointDeclineReason.EXCEPTION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDeclineMessage(DeclineCheckpoint message) {
        if (this.shutdown || message == null) {
            return;
        }
        if (!this.job.equals((Object)message.getJob())) {
            throw new IllegalArgumentException("Received DeclineCheckpoint message for job " + message.getJob() + " while this coordinator handles job " + this.job);
        }
        long checkpointId = message.getCheckpointId();
        String reason = message.getReason() != null ? message.getReason().getMessage() : "";
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            PendingCheckpoint checkpoint = this.pendingCheckpoints.remove(checkpointId);
            if (checkpoint != null && !checkpoint.isDiscarded()) {
                LOG.info("Decline checkpoint {} by task {} of job {}.", new Object[]{checkpointId, message.getTaskExecutionId(), this.job});
                this.discardCheckpoint(checkpoint, message.getReason());
            } else {
                if (checkpoint != null) {
                    throw new IllegalStateException("Received message for discarded but non-removed checkpoint " + checkpointId);
                }
                if (LOG.isDebugEnabled()) {
                    if (this.recentPendingCheckpoints.contains(checkpointId)) {
                        LOG.debug("Received another decline message for now expired checkpoint attempt {} of job {} : {}", new Object[]{checkpointId, this.job, reason});
                    } else {
                        LOG.debug("Received decline message for unknown (too old?) checkpoint attempt {} of job {} : {}", new Object[]{checkpointId, this.job, reason});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receiveAcknowledgeMessage(AcknowledgeCheckpoint message) throws CheckpointException {
        if (this.shutdown || message == null) {
            return false;
        }
        if (!this.job.equals((Object)message.getJob())) {
            LOG.error("Received wrong AcknowledgeCheckpoint message for job {}: {}", (Object)this.job, (Object)message);
            return false;
        }
        long checkpointId = message.getCheckpointId();
        Object object = this.lock;
        synchronized (object) {
            boolean wasPendingCheckpoint;
            if (this.shutdown) {
                return false;
            }
            PendingCheckpoint checkpoint = this.pendingCheckpoints.get(checkpointId);
            if (checkpoint != null && !checkpoint.isDiscarded()) {
                switch (checkpoint.acknowledgeTask(message.getTaskExecutionId(), message.getSubtaskState(), message.getCheckpointMetrics())) {
                    case SUCCESS: {
                        LOG.debug("Received acknowledge message for checkpoint {} from task {} of job {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob()});
                        if (!checkpoint.isFullyAcknowledged()) break;
                        this.completePendingCheckpoint(checkpoint);
                        break;
                    }
                    case DUPLICATE: {
                        LOG.debug("Received a duplicate acknowledge message for checkpoint {}, task {}, job {}.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob()});
                        break;
                    }
                    case UNKNOWN: {
                        LOG.warn("Could not acknowledge the checkpoint {} for task {} of job {}, because the task's execution attempt id was unknown. Discarding the state handle to avoid lingering state.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob()});
                        this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
                        break;
                    }
                    case DISCARDED: {
                        LOG.warn("Could not acknowledge the checkpoint {} for task {} of job {}, because the pending checkpoint had been discarded. Discarding the state handle tp avoid lingering state.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob()});
                        this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
                    }
                }
                return true;
            }
            if (checkpoint != null) {
                throw new IllegalStateException("Received message for discarded but non-removed checkpoint " + checkpointId);
            }
            if (this.recentPendingCheckpoints.contains(checkpointId)) {
                wasPendingCheckpoint = true;
                LOG.warn("Received late message for now expired checkpoint attempt {} from {} of job {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob()});
            } else {
                LOG.debug("Received message for an unknown checkpoint {} from {} of job {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob()});
                wasPendingCheckpoint = false;
            }
            this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
            return wasPendingCheckpoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePendingCheckpoint(PendingCheckpoint pendingCheckpoint) throws CheckpointException {
        CompletedCheckpoint completedCheckpoint;
        long checkpointId = pendingCheckpoint.getCheckpointId();
        Map<OperatorID, OperatorState> operatorStates = pendingCheckpoint.getOperatorStates();
        this.sharedStateRegistry.registerAll(operatorStates.values());
        try {
            try {
                completedCheckpoint = pendingCheckpoint.finalizeCheckpoint();
            }
            catch (Exception e1) {
                if (!pendingCheckpoint.isDiscarded()) {
                    pendingCheckpoint.abortError(e1);
                }
                throw new CheckpointException("Could not finalize the pending checkpoint " + checkpointId + '.', e1);
            }
            Preconditions.checkState((pendingCheckpoint.isDiscarded() && completedCheckpoint != null ? 1 : 0) != 0);
            try {
                this.completedCheckpointStore.addCheckpoint(completedCheckpoint);
            }
            catch (Exception exception) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            completedCheckpoint.discardOnFailedStoring();
                        }
                        catch (Throwable t) {
                            LOG.warn("Could not properly discard completed checkpoint {}.", (Object)completedCheckpoint.getCheckpointID(), (Object)t);
                        }
                    }
                });
                throw new CheckpointException("Could not complete the pending checkpoint " + checkpointId + '.', exception);
            }
        }
        finally {
            this.pendingCheckpoints.remove(checkpointId);
            this.triggerQueuedRequests();
        }
        this.rememberRecentCheckpointId(checkpointId);
        this.dropSubsumedCheckpoints(checkpointId);
        this.lastCheckpointCompletionNanos = System.nanoTime();
        LOG.info("Completed checkpoint {} for job {} ({} bytes in {} ms).", new Object[]{checkpointId, this.job, completedCheckpoint.getStateSize(), completedCheckpoint.getDuration()});
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Checkpoint state: ");
            for (OperatorState state : completedCheckpoint.getOperatorStates().values()) {
                builder.append(state);
                builder.append(", ");
            }
            builder.setLength(builder.length() - 2);
            LOG.debug(builder.toString());
        }
        long timestamp = completedCheckpoint.getTimestamp();
        for (ExecutionVertex ev : this.tasksToCommitTo) {
            Execution ee = ev.getCurrentExecutionAttempt();
            if (ee == null) continue;
            ee.notifyCheckpointComplete(checkpointId, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failUnacknowledgedPendingCheckpointsFor(ExecutionAttemptID executionAttemptId, Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<PendingCheckpoint> pendingCheckpointIterator = this.pendingCheckpoints.values().iterator();
            while (pendingCheckpointIterator.hasNext()) {
                PendingCheckpoint pendingCheckpoint = pendingCheckpointIterator.next();
                if (pendingCheckpoint.isAcknowledgedBy(executionAttemptId)) continue;
                pendingCheckpointIterator.remove();
                this.discardCheckpoint(pendingCheckpoint, cause);
            }
        }
    }

    private void rememberRecentCheckpointId(long id) {
        if (this.recentPendingCheckpoints.size() >= 16) {
            this.recentPendingCheckpoints.removeFirst();
        }
        this.recentPendingCheckpoints.addLast(id);
    }

    private void dropSubsumedCheckpoints(long checkpointId) {
        Iterator<Map.Entry<Long, PendingCheckpoint>> entries = this.pendingCheckpoints.entrySet().iterator();
        while (entries.hasNext()) {
            PendingCheckpoint p = entries.next().getValue();
            if (p.getCheckpointId() >= checkpointId || !p.canBeSubsumed()) continue;
            this.rememberRecentCheckpointId(p.getCheckpointId());
            p.abortSubsumed();
            entries.remove();
        }
    }

    private void triggerQueuedRequests() {
        if (this.triggerRequestQueued) {
            this.triggerRequestQueued = false;
            if (this.periodicScheduling) {
                if (this.currentPeriodicTrigger != null) {
                    this.currentPeriodicTrigger.cancel(false);
                }
                this.currentPeriodicTrigger = this.timer.scheduleAtFixedRate(new ScheduledTrigger(), 0L, this.baseInterval, TimeUnit.MILLISECONDS);
            } else {
                this.timer.execute(new ScheduledTrigger());
            }
        }
    }

    @VisibleForTesting
    int getNumScheduledTasks() {
        return this.timer.getQueue().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreLatestCheckpointedState(Map<JobVertexID, ExecutionJobVertex> tasks, boolean errorIfNoCheckpoint, boolean allowNonRestoredState) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalStateException("CheckpointCoordinator is shut down");
            }
            this.sharedStateRegistry.close();
            this.sharedStateRegistry = this.sharedStateRegistryFactory.create(this.executor);
            this.completedCheckpointStore.recover();
            for (CompletedCheckpoint completedCheckpoint : this.completedCheckpointStore.getAllCheckpoints()) {
                completedCheckpoint.registerSharedStatesAfterRestored(this.sharedStateRegistry);
            }
            LOG.debug("Status of the shared state registry of job {} after restore: {}.", (Object)this.job, (Object)this.sharedStateRegistry);
            CompletedCheckpoint latest = this.completedCheckpointStore.getLatestCheckpoint();
            if (latest == null) {
                if (errorIfNoCheckpoint) {
                    throw new IllegalStateException("No completed checkpoint available");
                }
                LOG.debug("Resetting the master hooks.");
                MasterHooks.reset(this.masterHooks.values(), LOG);
                return false;
            }
            LOG.info("Restoring job {} from latest valid checkpoint: {}.", (Object)this.job, (Object)latest);
            Map<OperatorID, OperatorState> operatorStates = latest.getOperatorStates();
            StateAssignmentOperation stateAssignmentOperation = new StateAssignmentOperation(latest.getCheckpointID(), tasks, operatorStates, allowNonRestoredState);
            stateAssignmentOperation.assignStates();
            MasterHooks.restoreMasterHooks(this.masterHooks, latest.getMasterHookStates(), latest.getCheckpointID(), allowNonRestoredState, LOG);
            if (this.statsTracker != null) {
                long restoreTimestamp = System.currentTimeMillis();
                RestoredCheckpointStats restored = new RestoredCheckpointStats(latest.getCheckpointID(), latest.getProperties(), restoreTimestamp, latest.getExternalPointer());
                this.statsTracker.reportRestoredCheckpoint(restored);
            }
            return true;
        }
    }

    public boolean restoreSavepoint(String savepointPointer, boolean allowNonRestored, Map<JobVertexID, ExecutionJobVertex> tasks, ClassLoader userClassLoader) throws Exception {
        Preconditions.checkNotNull((Object)savepointPointer, (String)"The savepoint path cannot be null.");
        LOG.info("Starting job {} from savepoint {} ({})", new Object[]{this.job, savepointPointer, allowNonRestored ? "allowing non restored state" : ""});
        CompletedCheckpointStorageLocation checkpointLocation = this.checkpointStorage.resolveCheckpoint(savepointPointer);
        CompletedCheckpoint savepoint = Checkpoints.loadAndValidateCheckpoint(this.job, tasks, checkpointLocation, userClassLoader, allowNonRestored);
        this.completedCheckpointStore.addCheckpoint(savepoint);
        long nextCheckpointId = savepoint.getCheckpointID() + 1L;
        this.checkpointIdCounter.setCount(nextCheckpointId);
        LOG.info("Reset the checkpoint ID of job {} to {}.", (Object)this.job, (Object)nextCheckpointId);
        return this.restoreLatestCheckpointedState(tasks, true, allowNonRestored);
    }

    public int getNumberOfPendingCheckpoints() {
        return this.pendingCheckpoints.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRetainedSuccessfulCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return this.completedCheckpointStore.getNumberOfRetainedCheckpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, PendingCheckpoint> getPendingCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<Long, PendingCheckpoint>(this.pendingCheckpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletedCheckpoint> getSuccessfulCheckpoints() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            return this.completedCheckpointStore.getAllCheckpoints();
        }
    }

    public CheckpointStorage getCheckpointStorage() {
        return this.checkpointStorage;
    }

    public CompletedCheckpointStore getCheckpointStore() {
        return this.completedCheckpointStore;
    }

    public CheckpointIDCounter getCheckpointIdCounter() {
        return this.checkpointIdCounter;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public boolean isPeriodicCheckpointingConfigured() {
        return this.baseInterval != Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckpointScheduler() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalArgumentException("Checkpoint coordinator is shut down");
            }
            this.stopCheckpointScheduler();
            this.periodicScheduling = true;
            long initialDelay = ThreadLocalRandom.current().nextLong(this.minPauseBetweenCheckpointsNanos / 1000000L, this.baseInterval + 1L);
            this.currentPeriodicTrigger = this.timer.scheduleAtFixedRate(new ScheduledTrigger(), initialDelay, this.baseInterval, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCheckpointScheduler() {
        Object object = this.lock;
        synchronized (object) {
            this.triggerRequestQueued = false;
            this.periodicScheduling = false;
            if (this.currentPeriodicTrigger != null) {
                this.currentPeriodicTrigger.cancel(false);
                this.currentPeriodicTrigger = null;
            }
            for (PendingCheckpoint p : this.pendingCheckpoints.values()) {
                p.abortError(new Exception("Checkpoint Coordinator is suspending."));
            }
            this.pendingCheckpoints.clear();
            this.numUnsuccessfulCheckpointsTriggers.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatusListener createActivatorDeactivator() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalArgumentException("Checkpoint coordinator is shut down");
            }
            if (this.jobStatusListener == null) {
                this.jobStatusListener = new CheckpointCoordinatorDeActivator(this);
            }
            return this.jobStatusListener;
        }
    }

    private void discardCheckpoint(PendingCheckpoint pendingCheckpoint, @Nullable Throwable cause) {
        assert (Thread.holdsLock(this.lock));
        Preconditions.checkNotNull((Object)pendingCheckpoint);
        long checkpointId = pendingCheckpoint.getCheckpointId();
        LOG.info("Discarding checkpoint {} of job {}.", new Object[]{checkpointId, this.job, cause});
        if (cause == null || cause instanceof CheckpointDeclineException) {
            pendingCheckpoint.abortDeclined();
        } else {
            pendingCheckpoint.abortError(cause);
        }
        this.rememberRecentCheckpointId(checkpointId);
        boolean haveMoreRecentPending = false;
        for (PendingCheckpoint p : this.pendingCheckpoints.values()) {
            if (p.isDiscarded() || p.getCheckpointId() < pendingCheckpoint.getCheckpointId()) continue;
            haveMoreRecentPending = true;
            break;
        }
        if (!haveMoreRecentPending) {
            this.triggerQueuedRequests();
        }
    }

    private void discardSubtaskState(final JobID jobId, final ExecutionAttemptID executionAttemptID, final long checkpointId, final TaskStateSnapshot subtaskState) {
        if (subtaskState != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        subtaskState.discardState();
                    }
                    catch (Throwable t2) {
                        LOG.warn("Could not properly discard state object of checkpoint {} belonging to task {} of job {}.", new Object[]{checkpointId, executionAttemptID, jobId, t2});
                    }
                }
            });
        }
    }

    private final class ScheduledTrigger
    implements Runnable {
        private ScheduledTrigger() {
        }

        @Override
        public void run() {
            try {
                CheckpointCoordinator.this.triggerCheckpoint(System.currentTimeMillis(), true);
            }
            catch (Exception e) {
                LOG.error("Exception while triggering checkpoint for job {}.", (Object)CheckpointCoordinator.this.job, (Object)e);
            }
        }
    }
}

