/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class KeyGroupsStateHandle
implements StreamStateHandle,
KeyedStateHandle {
    private static final long serialVersionUID = -8070326169926626355L;
    private final KeyGroupRangeOffsets groupRangeOffsets;
    private final StreamStateHandle stateHandle;

    public KeyGroupsStateHandle(KeyGroupRangeOffsets groupRangeOffsets, StreamStateHandle streamStateHandle) {
        Preconditions.checkNotNull((Object)groupRangeOffsets);
        Preconditions.checkNotNull((Object)streamStateHandle);
        this.groupRangeOffsets = groupRangeOffsets;
        this.stateHandle = streamStateHandle;
    }

    public KeyGroupRangeOffsets getGroupRangeOffsets() {
        return this.groupRangeOffsets;
    }

    public StreamStateHandle getDelegateStateHandle() {
        return this.stateHandle;
    }

    public long getOffsetForKeyGroup(int keyGroupId) {
        return this.groupRangeOffsets.getKeyGroupOffset(keyGroupId);
    }

    @Override
    public KeyGroupsStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        return new KeyGroupsStateHandle(this.groupRangeOffsets.getIntersection(keyGroupRange), this.stateHandle);
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.groupRangeOffsets.getKeyGroupRange();
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
    }

    @Override
    public void discardState() throws Exception {
        this.stateHandle.discardState();
    }

    @Override
    public long getStateSize() {
        return this.stateHandle.getStateSize();
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.stateHandle.openInputStream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyGroupsStateHandle)) {
            return false;
        }
        KeyGroupsStateHandle that = (KeyGroupsStateHandle)o;
        if (!this.groupRangeOffsets.equals(that.groupRangeOffsets)) {
            return false;
        }
        return this.stateHandle.equals(that.stateHandle);
    }

    public int hashCode() {
        int result = this.groupRangeOffsets.hashCode();
        result = 31 * result + this.stateHandle.hashCode();
        return result;
    }

    public String toString() {
        return "KeyGroupsStateHandle{groupRangeOffsets=" + this.groupRangeOffsets + ", stateHandle=" + this.stateHandle + '}';
    }
}

