/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredOperatorStateBackendMetaInfo<S>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final OperatorStateHandle.Mode assignmentMode;
    @Nonnull
    private final TypeSerializer<S> partitionStateSerializer;

    public RegisteredOperatorStateBackendMetaInfo(@Nonnull String name, @Nonnull TypeSerializer<S> partitionStateSerializer, @Nonnull OperatorStateHandle.Mode assignmentMode) {
        super(name);
        this.partitionStateSerializer = partitionStateSerializer;
        this.assignmentMode = assignmentMode;
    }

    private RegisteredOperatorStateBackendMetaInfo(@Nonnull RegisteredOperatorStateBackendMetaInfo<S> copy) {
        this(((RegisteredOperatorStateBackendMetaInfo)Preconditions.checkNotNull(copy)).name, copy.partitionStateSerializer.duplicate(), copy.assignmentMode);
    }

    public RegisteredOperatorStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), (TypeSerializer)Preconditions.checkNotNull(snapshot.restoreTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER)), OperatorStateHandle.Mode.valueOf(snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.OPERATOR_STATE_DISTRIBUTION_MODE)));
        Preconditions.checkState((StateMetaInfoSnapshot.BackendStateType.OPERATOR == snapshot.getBackendStateType() ? 1 : 0) != 0);
    }

    @Nonnull
    public RegisteredOperatorStateBackendMetaInfo<S> deepCopy() {
        return new RegisteredOperatorStateBackendMetaInfo<S>(this);
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Nonnull
    public OperatorStateHandle.Mode getAssignmentMode() {
        return this.assignmentMode;
    }

    @Nonnull
    public TypeSerializer<S> getPartitionStateSerializer() {
        return this.partitionStateSerializer;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof RegisteredOperatorStateBackendMetaInfo && this.name.equals(((RegisteredOperatorStateBackendMetaInfo)obj).getName()) && this.assignmentMode.equals((Object)((RegisteredOperatorStateBackendMetaInfo)obj).getAssignmentMode()) && this.partitionStateSerializer.equals(((RegisteredOperatorStateBackendMetaInfo)obj).getPartitionStateSerializer());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getAssignmentMode().hashCode();
        result = 31 * result + this.getPartitionStateSerializer().hashCode();
        return result;
    }

    public String toString() {
        return "RegisteredOperatorBackendStateMetaInfo{name='" + this.name + "', assignmentMode=" + (Object)((Object)this.assignmentMode) + ", partitionStateSerializer=" + this.partitionStateSerializer + '}';
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.OPERATOR_STATE_DISTRIBUTION_MODE.toString(), this.assignmentMode.toString());
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        Map<String, TypeSerializer<?>> serializerMap = Collections.singletonMap(valueSerializerKey, this.partitionStateSerializer.duplicate());
        Map<String, TypeSerializerSnapshot<?>> serializerConfigSnapshotsMap = Collections.singletonMap(valueSerializerKey, this.partitionStateSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.OPERATOR, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }
}

