/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.akka.AkkaJobManagerGateway;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.akka.ActorSystemScheduledExecutorAdapter;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.util.Preconditions;

public class AkkaJobManagerRetriever
extends LeaderGatewayRetriever<JobManagerGateway> {
    private final ActorSystem actorSystem;
    private final Time timeout;
    private final int retries;
    private final Time retryDelay;
    private final ScheduledExecutor scheduledExecutor;

    public AkkaJobManagerRetriever(ActorSystem actorSystem, Time timeout, int retries, Time retryDelay) {
        this.actorSystem = (ActorSystem)Preconditions.checkNotNull((Object)actorSystem);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (Object)"The number of retries must be >= 0.");
        this.retries = retries;
        this.retryDelay = (Time)Preconditions.checkNotNull((Object)retryDelay);
        this.scheduledExecutor = new ActorSystemScheduledExecutorAdapter(actorSystem);
    }

    @Override
    protected CompletableFuture<JobManagerGateway> createGateway(CompletableFuture<Tuple2<String, UUID>> leaderFuture) {
        return FutureUtils.retryWithDelay(() -> leaderFuture.thenCompose(addressLeaderId -> FutureUtils.toJava(AkkaUtils.getActorRefFuture((String)addressLeaderId.f0, this.actorSystem, FutureUtils.toFiniteDuration(this.timeout))).thenApply(jobManagerRef -> {
            AkkaActorGateway leaderGateway = new AkkaActorGateway((ActorRef)jobManagerRef, (UUID)addressLeaderId.f1);
            return new AkkaJobManagerGateway(leaderGateway);
        })), this.retries, this.retryDelay, this.scheduledExecutor);
    }
}

