/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.function.Function;
import org.apache.flink.runtime.executiongraph.failover.flip1.ResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.io.network.partition.PartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class ExecutionGraphResultPartitionAvailabilityChecker
implements ResultPartitionAvailabilityChecker {
    private final Function<IntermediateResultPartitionID, ResultPartitionID> partitionIDMapper;
    private final PartitionTracker partitionTracker;

    ExecutionGraphResultPartitionAvailabilityChecker(Function<IntermediateResultPartitionID, ResultPartitionID> partitionIDMapper, PartitionTracker partitionTracker) {
        this.partitionIDMapper = (Function)Preconditions.checkNotNull(partitionIDMapper);
        this.partitionTracker = (PartitionTracker)Preconditions.checkNotNull((Object)partitionTracker);
    }

    @Override
    public boolean isAvailable(IntermediateResultPartitionID resultPartitionID) {
        return this.partitionTracker.isPartitionTracked(this.partitionIDMapper.apply(resultPartitionID));
    }
}

