/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.leaderelection;

import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleLeaderElectionService
implements LeaderElectionService {
    private static final Logger LOG = LoggerFactory.getLogger(SingleLeaderElectionService.class);
    private final Object lock = new Object();
    private final Executor notificationExecutor;
    private final UUID leaderId;
    @GuardedBy(value="lock")
    private final HashSet<EmbeddedLeaderRetrievalService> listeners;
    @GuardedBy(value="lock")
    private volatile LeaderContender proposedLeader;
    @GuardedBy(value="lock")
    private volatile LeaderContender leader;
    @GuardedBy(value="lock")
    private volatile String leaderAddress;
    @GuardedBy(value="lock")
    private volatile boolean shutdown;

    public SingleLeaderElectionService(Executor notificationsDispatcher, UUID leaderId) {
        this.notificationExecutor = (Executor)Preconditions.checkNotNull((Object)notificationsDispatcher);
        this.leaderId = (UUID)Preconditions.checkNotNull((Object)leaderId);
        this.listeners = new HashSet();
        this.shutdown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(LeaderContender contender) throws Exception {
        Preconditions.checkNotNull((Object)contender, (String)"contender");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"service is shut down");
            Preconditions.checkState((this.proposedLeader == null ? 1 : 0) != 0, (Object)"service already started");
            this.proposedLeader = contender;
            this.notificationExecutor.execute(new GrantLeadershipCall(contender, this.leaderId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            for (EmbeddedLeaderRetrievalService listener : this.listeners) {
                this.notificationExecutor.execute(new NotifyOfLeaderCall(null, null, listener.listener, LOG));
            }
            if (this.leader != null) {
                try {
                    this.leader.revokeLeadership();
                }
                catch (Throwable t) {
                    this.leader.handleError(t instanceof Exception ? (Exception)t : new Exception(t));
                }
            }
            this.proposedLeader = null;
            this.leader = null;
            this.leaderAddress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmLeaderSessionID(UUID leaderSessionID) {
        Preconditions.checkNotNull((Object)leaderSessionID, (String)"leaderSessionID");
        Preconditions.checkArgument((boolean)leaderSessionID.equals(this.leaderId), (Object)"confirmed wrong leader session id");
        Object object = this.lock;
        synchronized (object) {
            String address;
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"service is shut down");
            Preconditions.checkState((this.proposedLeader != null ? 1 : 0) != 0, (Object)"no leader proposed yet");
            Preconditions.checkState((this.leader == null ? 1 : 0) != 0, (Object)"leader already confirmed");
            this.leaderAddress = address = this.proposedLeader.getAddress();
            this.leader = this.proposedLeader;
            for (EmbeddedLeaderRetrievalService listener : this.listeners) {
                this.notificationExecutor.execute(new NotifyOfLeaderCall(address, this.leaderId, listener.listener, LOG));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLeadership(@Nonnull UUID leaderSessionId) {
        Object object = this.lock;
        synchronized (object) {
            return this.proposedLeader != null && leaderSessionId.equals(this.leaderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void errorOnGrantLeadership(LeaderContender contender, Throwable error) {
        LOG.warn("Error granting leadership to contender", error);
        contender.handleError(error instanceof Exception ? (Exception)error : new Exception(error));
        Object object = this.lock;
        synchronized (object) {
            if (this.proposedLeader == contender) {
                this.proposedLeader = null;
                this.leader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    public void shutdown() {
        this.shutdownInternally(new Exception("The leader service is shutting down"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownInternally(Exception exceptionForHandlers) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            if (this.leader != null) {
                try {
                    this.leader.handleError(exceptionForHandlers);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.leader = null;
            this.proposedLeader = null;
            this.leaderAddress = null;
            for (EmbeddedLeaderRetrievalService service : this.listeners) {
                service.shutdown(exceptionForHandlers);
            }
            this.listeners.clear();
        }
    }

    private void fatalError(Throwable error) {
        LOG.error("Embedded leader election service encountered a fatal error. Shutting down service.", error);
        this.shutdownInternally(new Exception("Leader election service is shutting down after a fatal error", error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaderRetrievalService createLeaderRetrievalService() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"leader election service is shut down");
            return new EmbeddedLeaderRetrievalService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(EmbeddedLeaderRetrievalService service, LeaderRetrievalListener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"leader election service is shut down");
            Preconditions.checkState((!service.running ? 1 : 0) != 0, (Object)"leader retrieval service is already started");
            try {
                if (!this.listeners.add(service)) {
                    throw new IllegalStateException("leader retrieval service was added to this service multiple times");
                }
                service.listener = listener;
                service.running = true;
                if (this.leader != null) {
                    this.notificationExecutor.execute(new NotifyOfLeaderCall(this.leaderAddress, this.leaderId, listener, LOG));
                }
            }
            catch (Throwable t) {
                this.fatalError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(EmbeddedLeaderRetrievalService service) {
        Object object = this.lock;
        synchronized (object) {
            if (!service.running || this.shutdown) {
                return;
            }
            try {
                if (!this.listeners.remove(service)) {
                    throw new IllegalStateException("leader retrieval service does not belong to this service");
                }
                service.listener = null;
                service.running = false;
            }
            catch (Throwable t) {
                this.fatalError(t);
            }
        }
    }

    private static class NotifyOfLeaderCall
    implements Runnable {
        @Nullable
        private final String address;
        @Nullable
        private final UUID leaderSessionId;
        private final LeaderRetrievalListener listener;
        private final Logger logger;

        NotifyOfLeaderCall(@Nullable String address, @Nullable UUID leaderSessionId, LeaderRetrievalListener listener, Logger logger) {
            this.address = address;
            this.leaderSessionId = leaderSessionId;
            this.listener = (LeaderRetrievalListener)Preconditions.checkNotNull((Object)listener);
            this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
        }

        @Override
        public void run() {
            try {
                this.listener.notifyLeaderAddress(this.address, this.leaderSessionId);
            }
            catch (Throwable t) {
                this.logger.warn("Error notifying leader listener about new leader", t);
                this.listener.handleError(t instanceof Exception ? (Exception)t : new Exception(t));
            }
        }
    }

    private class GrantLeadershipCall
    implements Runnable {
        private final LeaderContender contender;
        private final UUID leaderSessionId;

        GrantLeadershipCall(LeaderContender contender, UUID leaderSessionId) {
            this.contender = (LeaderContender)Preconditions.checkNotNull((Object)contender);
            this.leaderSessionId = (UUID)Preconditions.checkNotNull((Object)leaderSessionId);
        }

        @Override
        public void run() {
            try {
                this.contender.grantLeadership(this.leaderSessionId);
            }
            catch (Throwable t) {
                SingleLeaderElectionService.this.errorOnGrantLeadership(this.contender, t);
            }
        }
    }

    private class EmbeddedLeaderRetrievalService
    implements LeaderRetrievalService {
        volatile LeaderRetrievalListener listener;
        volatile boolean running;

        private EmbeddedLeaderRetrievalService() {
        }

        @Override
        public void start(LeaderRetrievalListener listener) throws Exception {
            Preconditions.checkNotNull((Object)listener);
            SingleLeaderElectionService.this.addListener(this, listener);
        }

        @Override
        public void stop() throws Exception {
            SingleLeaderElectionService.this.removeListener(this);
        }

        void shutdown(Exception cause) {
            if (this.running) {
                LeaderRetrievalListener lst = this.listener;
                this.running = false;
                this.listener = null;
                try {
                    lst.handleError(cause);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

