/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotSharingGroupAssignment {
    private static final Logger LOG = LoggerFactory.getLogger(SlotSharingGroupAssignment.class);
    private final Object lock = new Object();
    private final Set<SharedSlot> allSlots = new LinkedHashSet<SharedSlot>();
    private final Map<AbstractID, Map<ResourceID, List<SharedSlot>>> availableSlotsPerJid = new LinkedHashMap<AbstractID, Map<ResourceID, List<SharedSlot>>>();

    public int getNumberOfSlots() {
        return this.allSlots.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableSlotsForGroup(AbstractID groupId) {
        Object object = this.lock;
        synchronized (object) {
            Map<ResourceID, List<SharedSlot>> available = this.availableSlotsPerJid.get(groupId);
            if (available != null) {
                HashSet<SharedSlot> set = new HashSet<SharedSlot>();
                for (List<SharedSlot> list : available.values()) {
                    for (SharedSlot slot : list) {
                        set.add(slot);
                    }
                }
                return set.size();
            }
            return this.allSlots.size();
        }
    }

    public SimpleSlot addSharedSlotAndAllocateSubSlot(SharedSlot sharedSlot, Locality locality, JobVertexID groupId) {
        return this.addSharedSlotAndAllocateSubSlot(sharedSlot, locality, groupId, null);
    }

    public SimpleSlot addSharedSlotAndAllocateSubSlot(SharedSlot sharedSlot, Locality locality, CoLocationConstraint constraint) {
        return this.addSharedSlotAndAllocateSubSlot(sharedSlot, locality, null, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleSlot addSharedSlotAndAllocateSubSlot(SharedSlot sharedSlot, Locality locality, JobVertexID groupId, CoLocationConstraint constraint) {
        if (!sharedSlot.isRootAndEmpty()) {
            throw new IllegalArgumentException("The given slot is not an empty root slot.");
        }
        ResourceID location = sharedSlot.getTaskManagerID();
        Object object = this.lock;
        synchronized (object) {
            JobVertexID groupIdForMap;
            SimpleSlot subSlot;
            if (!sharedSlot.isAlive()) {
                return null;
            }
            if (!this.allSlots.add(sharedSlot)) {
                throw new IllegalArgumentException("Slot was already contained in the assignment group");
            }
            if (constraint == null) {
                subSlot = sharedSlot.allocateSubSlot(groupId);
                groupIdForMap = groupId;
            } else {
                if (constraint.isAssignedAndAlive()) {
                    throw new IllegalStateException("Trying to add a shared slot to a co-location constraint that has a life slot.");
                }
                SharedSlot constraintGroupSlot = sharedSlot.allocateSharedSlot(constraint.getGroupId());
                groupIdForMap = constraint.getGroupId();
                if (constraintGroupSlot != null) {
                    subSlot = constraintGroupSlot.allocateSubSlot(null);
                    if (subSlot != null) {
                        constraint.setSharedSlot(constraintGroupSlot);
                    } else {
                        constraintGroupSlot.releaseSlot(new FlinkException("Could not create a sub slot in this shared slot."));
                    }
                } else {
                    subSlot = null;
                }
            }
            if (subSlot != null) {
                subSlot.setLocality(locality);
                boolean entryForNewJidExists = false;
                for (Map.Entry<AbstractID, Map<ResourceID, List<SharedSlot>>> entry : this.availableSlotsPerJid.entrySet()) {
                    if (entry.getKey().equals((Object)groupIdForMap)) {
                        entryForNewJidExists = true;
                        continue;
                    }
                    Map<ResourceID, List<SharedSlot>> available = entry.getValue();
                    SlotSharingGroupAssignment.putIntoMultiMap(available, location, sharedSlot);
                }
                if (!entryForNewJidExists) {
                    this.availableSlotsPerJid.put(groupIdForMap, new LinkedHashMap());
                }
                return subSlot;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleSlot getSlotForTask(JobVertexID vertexID, Iterable<TaskManagerLocation> locationPreferences) {
        Object object = this.lock;
        synchronized (object) {
            Tuple2<SharedSlot, Locality> p = this.getSharedSlotForTask(vertexID, locationPreferences, false);
            if (p != null) {
                SharedSlot ss = (SharedSlot)p.f0;
                SimpleSlot slot = ss.allocateSubSlot(vertexID);
                slot.setLocality((Locality)((Object)p.f1));
                return slot;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleSlot getSlotForTask(CoLocationConstraint constraint, Iterable<TaskManagerLocation> locationPreferences) {
        Object object = this.lock;
        synchronized (object) {
            if (constraint.isAssignedAndAlive()) {
                SharedSlot shared = constraint.getSharedSlot();
                SimpleSlot subslot = shared.allocateSubSlot(null);
                subslot.setLocality(Locality.LOCAL);
                return subslot;
            }
            if (constraint.isAssigned()) {
                SharedSlot previous = constraint.getSharedSlot();
                if (previous == null) {
                    throw new IllegalStateException("Bug: Found assigned co-location constraint without a slot.");
                }
                TaskManagerLocation location = previous.getTaskManagerLocation();
                Tuple2<SharedSlot, Locality> p = this.getSharedSlotForTask(constraint.getGroupId(), Collections.singleton(location), true);
                if (p == null) {
                    return null;
                }
                SharedSlot newSharedSlot = (SharedSlot)p.f0;
                SharedSlot constraintGroupSlot = newSharedSlot.allocateSharedSlot(constraint.getGroupId());
                if (constraintGroupSlot != null) {
                    constraint.setSharedSlot(constraintGroupSlot);
                    SimpleSlot subSlot = constraintGroupSlot.allocateSubSlot(null);
                    subSlot.setLocality(Locality.LOCAL);
                    return subSlot;
                }
                return null;
            }
            Tuple2<SharedSlot, Locality> p = this.getSharedSlotForTask(constraint.getGroupId(), locationPreferences, false);
            if (p == null) {
                return null;
            }
            SharedSlot availableShared = (SharedSlot)p.f0;
            Locality l = (Locality)((Object)p.f1);
            SharedSlot constraintGroupSlot = availableShared.allocateSharedSlot(constraint.getGroupId());
            constraint.setSharedSlot(constraintGroupSlot);
            SimpleSlot sub = constraintGroupSlot.allocateSubSlot(null);
            sub.setLocality(l);
            return sub;
        }
    }

    public Tuple2<SharedSlot, Locality> getSharedSlotForTask(AbstractID groupId, Iterable<TaskManagerLocation> preferredLocations, boolean localOnly) {
        SharedSlot slot;
        Locality locality;
        if (this.allSlots.isEmpty()) {
            return null;
        }
        Map<ResourceID, List<SharedSlot>> slotsForGroup = this.availableSlotsPerJid.get(groupId);
        if (slotsForGroup == null) {
            slotsForGroup = new LinkedHashMap<ResourceID, List<SharedSlot>>();
            this.availableSlotsPerJid.put(groupId, slotsForGroup);
            for (SharedSlot sharedSlot : this.allSlots) {
                SlotSharingGroupAssignment.putIntoMultiMap(slotsForGroup, sharedSlot.getTaskManagerID(), sharedSlot);
            }
        } else if (slotsForGroup.isEmpty()) {
            return null;
        }
        boolean didNotGetPreferred = false;
        if (preferredLocations != null) {
            for (TaskManagerLocation location : preferredLocations) {
                didNotGetPreferred = true;
                SharedSlot slot2 = SlotSharingGroupAssignment.removeFromMultiMap(slotsForGroup, location.getResourceID());
                if (slot2 == null || !slot2.isAlive()) continue;
                return new Tuple2((Object)slot2, (Object)Locality.LOCAL);
            }
        }
        if (didNotGetPreferred && localOnly) {
            return null;
        }
        Locality locality2 = locality = didNotGetPreferred ? Locality.NON_LOCAL : Locality.UNCONSTRAINED;
        while ((slot = SlotSharingGroupAssignment.pollFromMultiMap(slotsForGroup)) != null) {
            if (!slot.isAlive()) continue;
            return new Tuple2((Object)slot, (Object)locality);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSimpleSlot(SimpleSlot simpleSlot) {
        Object object = this.lock;
        synchronized (object) {
            if (simpleSlot.markCancelled()) {
                if (simpleSlot.isAlive()) {
                    throw new IllegalStateException("slot is still alive");
                }
                if (simpleSlot.markReleased()) {
                    LOG.debug("Release simple slot {}.", (Object)simpleSlot);
                    AbstractID groupID = simpleSlot.getGroupID();
                    SharedSlot parent = simpleSlot.getParent();
                    if (groupID != null && !this.allSlots.contains(parent)) {
                        throw new IllegalArgumentException("Slot was not associated with this SlotSharingGroup before.");
                    }
                    int parentRemaining = parent.removeDisposedChildSlot(simpleSlot);
                    if (parentRemaining > 0) {
                        if (groupID != null) {
                            Map<ResourceID, List<SharedSlot>> slotsForJid = this.availableSlotsPerJid.get(groupID);
                            if (slotsForJid == null) {
                                throw new IllegalStateException("Trying to return a slot for group " + groupID + " when available slots indicated that all slots were available.");
                            }
                            SlotSharingGroupAssignment.putIntoMultiMap(slotsForJid, parent.getTaskManagerID(), parent);
                        }
                    } else {
                        parent.markCancelled();
                        this.internalDisposeEmptySharedSlot(parent);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSharedSlot(SharedSlot sharedSlot) {
        Object object = this.lock;
        synchronized (object) {
            if (sharedSlot.markCancelled()) {
                if (sharedSlot.hasChildren()) {
                    FlinkException cause = new FlinkException("Releasing shared slot parent.");
                    Set<Slot> children = sharedSlot.getSubSlots();
                    while (children.size() > 0) {
                        children.iterator().next().releaseSlot(cause);
                    }
                } else {
                    this.internalDisposeEmptySharedSlot(sharedSlot);
                }
            }
        }
    }

    private void internalDisposeEmptySharedSlot(SharedSlot sharedSlot) {
        if (sharedSlot.isAlive() || !sharedSlot.getSubSlots().isEmpty()) {
            throw new IllegalArgumentException();
        }
        SharedSlot parent = sharedSlot.getParent();
        AbstractID groupID = sharedSlot.getGroupID();
        if (parent == null) {
            sharedSlot.getOwner().returnLogicalSlot(sharedSlot);
            this.allSlots.remove(sharedSlot);
            SlotSharingGroupAssignment.removeSlotFromAllEntries(this.availableSlotsPerJid, sharedSlot);
        } else if (groupID != null) {
            if (sharedSlot.markReleased()) {
                LOG.debug("Internally dispose empty shared slot {}.", (Object)sharedSlot);
                int parentRemaining = parent.removeDisposedChildSlot(sharedSlot);
                if (parentRemaining > 0) {
                    Map<ResourceID, List<SharedSlot>> slotsForGroup = this.availableSlotsPerJid.get(groupID);
                    if (slotsForGroup == null) {
                        throw new IllegalStateException("Trying to return a slot for group " + groupID + " when available slots indicated that all slots were available.");
                    }
                    SlotSharingGroupAssignment.putIntoMultiMap(slotsForGroup, parent.getTaskManagerID(), parent);
                } else {
                    parent.markCancelled();
                    this.internalDisposeEmptySharedSlot(parent);
                }
            }
        } else {
            throw new IllegalStateException("Found a shared slot that is neither a root slot, nor associated with a vertex group.");
        }
    }

    private static void putIntoMultiMap(Map<ResourceID, List<SharedSlot>> map, ResourceID location, SharedSlot slot) {
        List<SharedSlot> slotsForInstance = map.get(location);
        if (slotsForInstance == null) {
            slotsForInstance = new ArrayList<SharedSlot>();
            map.put(location, slotsForInstance);
        }
        slotsForInstance.add(slot);
    }

    private static SharedSlot removeFromMultiMap(Map<ResourceID, List<SharedSlot>> map, ResourceID location) {
        List<SharedSlot> slotsForLocation = map.get(location);
        if (slotsForLocation == null) {
            return null;
        }
        SharedSlot slot = slotsForLocation.remove(slotsForLocation.size() - 1);
        if (slotsForLocation.isEmpty()) {
            map.remove(location);
        }
        return slot;
    }

    private static SharedSlot pollFromMultiMap(Map<ResourceID, List<SharedSlot>> map) {
        Iterator<Map.Entry<ResourceID, List<SharedSlot>>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            List<SharedSlot> slots = iter.next().getValue();
            if (slots.isEmpty()) {
                iter.remove();
                continue;
            }
            if (slots.size() == 1) {
                SharedSlot slot = slots.remove(0);
                iter.remove();
                return slot;
            }
            return slots.remove(slots.size() - 1);
        }
        return null;
    }

    private static void removeSlotFromAllEntries(Map<AbstractID, Map<ResourceID, List<SharedSlot>>> availableSlots, SharedSlot slot) {
        ResourceID taskManagerId = slot.getTaskManagerID();
        for (Map.Entry<AbstractID, Map<ResourceID, List<SharedSlot>>> entry : availableSlots.entrySet()) {
            Map<ResourceID, List<SharedSlot>> map = entry.getValue();
            List<SharedSlot> list = map.get(taskManagerId);
            if (list == null) continue;
            list.remove(slot);
            if (!list.isEmpty()) continue;
            map.remove(taskManagerId);
        }
    }
}

