/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartition;

public class OutputBufferPoolUsageGauge
implements Gauge<Float> {
    private final ResultPartition[] resultPartitions;

    public OutputBufferPoolUsageGauge(ResultPartition[] resultPartitions) {
        this.resultPartitions = resultPartitions;
    }

    public Float getValue() {
        int usedBuffers = 0;
        int bufferPoolSize = 0;
        for (ResultPartition resultPartition : this.resultPartitions) {
            BufferPool bufferPool = resultPartition.getBufferPool();
            if (bufferPool == null) continue;
            usedBuffers += bufferPool.bestEffortGetNumOfUsedBuffers();
            bufferPoolSize += bufferPool.getNumBuffers();
        }
        if (bufferPoolSize != 0) {
            return Float.valueOf((float)usedBuffers / (float)bufferPoolSize);
        }
        return Float.valueOf(0.0f);
    }
}

