/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

public abstract class ResultSubpartition {
    protected final int index;
    protected final ResultPartition parent;

    public ResultSubpartition(int index, ResultPartition parent) {
        this.index = index;
        this.parent = parent;
    }

    protected abstract long getTotalNumberOfBuffers();

    protected abstract long getTotalNumberOfBytes();

    protected void onConsumedSubpartition() {
        this.parent.onConsumedSubpartition(this.index);
    }

    public abstract boolean add(BufferConsumer var1) throws IOException;

    public abstract void flush();

    public abstract void finish() throws IOException;

    public abstract void release() throws IOException;

    public abstract ResultSubpartitionView createReadView(BufferAvailabilityListener var1) throws IOException;

    abstract int releaseMemory() throws IOException;

    public abstract boolean isReleased();

    @VisibleForTesting
    abstract int getBuffersInBacklog();

    public abstract int unsynchronizedGetNumberOfQueuedBuffers();

    public static final class BufferAndBacklog {
        private final Buffer buffer;
        private final boolean isMoreAvailable;
        private final int buffersInBacklog;
        private final boolean nextBufferIsEvent;

        public BufferAndBacklog(Buffer buffer, boolean isMoreAvailable, int buffersInBacklog, boolean nextBufferIsEvent) {
            this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
            this.buffersInBacklog = buffersInBacklog;
            this.isMoreAvailable = isMoreAvailable;
            this.nextBufferIsEvent = nextBufferIsEvent;
        }

        public Buffer buffer() {
            return this.buffer;
        }

        public boolean isMoreAvailable() {
            return this.isMoreAvailable;
        }

        public int buffersInBacklog() {
            return this.buffersInBacklog;
        }

        public boolean nextBufferIsEvent() {
            return this.nextBufferIsEvent;
        }

        public static BufferAndBacklog fromBufferAndLookahead(Buffer current, Buffer lookahead, int backlog) {
            return new BufferAndBacklog(current, lookahead != null, backlog, lookahead != null && !lookahead.isBuffer());
        }
    }
}

