/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.AsyncDataInput;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.util.Preconditions;

public abstract class InputGate
implements AsyncDataInput<BufferOrEvent>,
AutoCloseable {
    protected CompletableFuture<?> isAvailable = new CompletableFuture();

    public abstract int getNumberOfInputChannels();

    @Override
    public abstract boolean isFinished();

    public abstract Optional<BufferOrEvent> getNext() throws IOException, InterruptedException;

    @Override
    public abstract Optional<BufferOrEvent> pollNext() throws IOException, InterruptedException;

    public abstract void sendTaskEvent(TaskEvent var1) throws IOException;

    @Override
    public CompletableFuture<?> isAvailable() {
        return this.isAvailable;
    }

    protected void resetIsAvailable() {
        if (this.isAvailable == AVAILABLE || this.isAvailable.isDone()) {
            this.isAvailable = new CompletableFuture();
        }
    }

    public abstract void setup() throws IOException, InterruptedException;

    protected static class InputWithData<INPUT, DATA> {
        protected final INPUT input;
        protected final DATA data;
        protected final boolean moreAvailable;

        InputWithData(INPUT input, DATA data, boolean moreAvailable) {
            this.input = Preconditions.checkNotNull(input);
            this.data = Preconditions.checkNotNull(data);
            this.moreAvailable = moreAvailable;
        }
    }
}

