/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;

public interface SlotSelectionStrategy {
    public Optional<SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull Collection<SlotInfoAndResources> var1, @Nonnull SlotProfile var2);

    public static final class SlotInfoAndLocality {
        @Nonnull
        private final SlotInfo slotInfo;
        @Nonnull
        private final Locality locality;

        private SlotInfoAndLocality(@Nonnull SlotInfo slotInfo, @Nonnull Locality locality) {
            this.slotInfo = slotInfo;
            this.locality = locality;
        }

        @Nonnull
        public SlotInfo getSlotInfo() {
            return this.slotInfo;
        }

        @Nonnull
        public Locality getLocality() {
            return this.locality;
        }

        public static SlotInfoAndLocality of(@Nonnull SlotInfo slotInfo, @Nonnull Locality locality) {
            return new SlotInfoAndLocality(slotInfo, locality);
        }
    }

    public static final class SlotInfoAndResources {
        @Nonnull
        private final SlotInfo slotInfo;
        @Nonnull
        private final ResourceProfile remainingResources;

        public SlotInfoAndResources(@Nonnull SlotInfo slotInfo) {
            this(slotInfo, slotInfo.getResourceProfile());
        }

        public SlotInfoAndResources(@Nonnull SlotInfo slotInfo, @Nonnull ResourceProfile remainingResources) {
            this.slotInfo = slotInfo;
            this.remainingResources = remainingResources;
        }

        @Nonnull
        public SlotInfo getSlotInfo() {
            return this.slotInfo;
        }

        @Nonnull
        public ResourceProfile getRemainingResources() {
            return this.remainingResources;
        }
    }
}

