/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.scheduler.DeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;

public class EagerSchedulingStrategy
implements SchedulingStrategy {
    private final SchedulerOperations schedulerOperations;
    private final SchedulingTopology schedulingTopology;
    private final DeploymentOption deploymentOption = new DeploymentOption(false);

    public EagerSchedulingStrategy(SchedulerOperations schedulerOperations, SchedulingTopology schedulingTopology) {
        this.schedulerOperations = (SchedulerOperations)Preconditions.checkNotNull((Object)schedulerOperations);
        this.schedulingTopology = (SchedulingTopology)Preconditions.checkNotNull((Object)schedulingTopology);
    }

    @Override
    public void startScheduling() {
        Set<ExecutionVertexID> allVertices = this.getAllVerticesFromTopology();
        this.allocateSlotsAndDeploy(allVertices);
    }

    @Override
    public void restartTasks(Set<ExecutionVertexID> verticesToRestart) {
        this.allocateSlotsAndDeploy(verticesToRestart);
    }

    @Override
    public void onExecutionStateChange(ExecutionVertexID executionVertexId, ExecutionState executionState) {
    }

    @Override
    public void onPartitionConsumable(ExecutionVertexID executionVertexId, ResultPartitionID resultPartitionId) {
    }

    private void allocateSlotsAndDeploy(Set<ExecutionVertexID> verticesToDeploy) {
        List<ExecutionVertexDeploymentOption> executionVertexDeploymentOptions = this.createExecutionVertexDeploymentOptions(verticesToDeploy);
        this.schedulerOperations.allocateSlotsAndDeploy(executionVertexDeploymentOptions);
    }

    private Set<ExecutionVertexID> getAllVerticesFromTopology() {
        return StreamSupport.stream(this.schedulingTopology.getVertices().spliterator(), false).map(SchedulingExecutionVertex::getId).collect(Collectors.toSet());
    }

    private List<ExecutionVertexDeploymentOption> createExecutionVertexDeploymentOptions(Collection<ExecutionVertexID> vertices) {
        ArrayList<ExecutionVertexDeploymentOption> executionVertexDeploymentOptions = new ArrayList<ExecutionVertexDeploymentOption>(vertices.size());
        for (ExecutionVertexID executionVertexID : vertices) {
            executionVertexDeploymentOptions.add(new ExecutionVertexDeploymentOption(executionVertexID, this.deploymentOption));
        }
        return executionVertexDeploymentOptions;
    }

    public static class Factory
    implements SchedulingStrategyFactory {
        @Override
        public SchedulingStrategy createInstance(SchedulerOperations schedulerOperations, SchedulingTopology schedulingTopology, JobGraph jobGraph) {
            return new EagerSchedulingStrategy(schedulerOperations, schedulingTopology);
        }
    }
}

