/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class ExecutionVertexID {
    private final JobVertexID jobVertexId;
    private final int subtaskIndex;

    public ExecutionVertexID(JobVertexID jobVertexId, int subtaskIndex) {
        Preconditions.checkArgument((subtaskIndex >= 0 ? 1 : 0) != 0, (Object)"subtaskIndex must be greater than or equal to 0");
        this.jobVertexId = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexId)));
        this.subtaskIndex = subtaskIndex;
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionVertexID that = (ExecutionVertexID)o;
        return this.subtaskIndex == that.subtaskIndex && this.jobVertexId.equals((Object)that.jobVertexId);
    }

    public int hashCode() {
        int result = this.jobVertexId.hashCode();
        result = 31 * result + this.subtaskIndex;
        return result;
    }

    public String toString() {
        return (Object)((Object)this.jobVertexId) + "_" + this.subtaskIndex;
    }
}

