/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.metrics;

import java.util.HashMap;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.JobStatusProvider;
import org.apache.flink.runtime.executiongraph.TestingJobStatusProvider;
import org.apache.flink.runtime.executiongraph.metrics.RestartTimeGauge;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RestartTimeGaugeTest
extends TestLogger {
    @Test
    public void testNotRestarted() {
        RestartTimeGauge gauge = new RestartTimeGauge((JobStatusProvider)new TestingJobStatusProvider(JobStatus.RUNNING, -1L));
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testInRestarting() {
        HashMap<JobStatus, Long> statusTimestampMap = new HashMap<JobStatus, Long>();
        statusTimestampMap.put(JobStatus.RESTARTING, 1L);
        RestartTimeGauge gauge = new RestartTimeGauge((JobStatusProvider)new TestingJobStatusProvider(JobStatus.RESTARTING, status -> statusTimestampMap.getOrDefault(status, -1L)));
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    @Test
    public void testRunningAfterRestarting() {
        HashMap<JobStatus, Long> statusTimestampMap = new HashMap<JobStatus, Long>();
        statusTimestampMap.put(JobStatus.RESTARTING, 123L);
        statusTimestampMap.put(JobStatus.RUNNING, 234L);
        RestartTimeGauge gauge = new RestartTimeGauge((JobStatusProvider)new TestingJobStatusProvider(JobStatus.RUNNING, status -> statusTimestampMap.getOrDefault(status, -1L)));
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)111L));
    }

    @Test
    public void testFailedAfterRestarting() {
        HashMap<JobStatus, Long> statusTimestampMap = new HashMap<JobStatus, Long>();
        statusTimestampMap.put(JobStatus.RESTARTING, 123L);
        statusTimestampMap.put(JobStatus.FAILED, 456L);
        RestartTimeGauge gauge = new RestartTimeGauge((JobStatusProvider)new TestingJobStatusProvider(JobStatus.FAILED, status -> statusTimestampMap.getOrDefault(status, -1L)));
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)333L));
    }
}

