/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.drivers;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.ReduceCombineDriver;
import org.apache.flink.runtime.operators.drivers.DriverTestData;
import org.apache.flink.runtime.operators.drivers.GatheringCollector;
import org.apache.flink.runtime.operators.drivers.TestTaskContext;
import org.apache.flink.runtime.util.EmptyMutableObjectIterator;
import org.apache.flink.runtime.util.RegularToMutableObjectIterator;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;

public class ReduceCombineDriverTest {
    @Test
    public void testImmutableEmpty() {
        try {
            TestTaskContext context = new TestTaskContext(0x100000L);
            context.getTaskConfig().setRelativeMemoryDriver(0.5);
            List<Tuple2<String, Integer>> data = DriverTestData.createReduceImmutableData();
            Collections.shuffle(data);
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            MutableObjectIterator input = EmptyMutableObjectIterator.get();
            context.setDriverStrategy(DriverStrategy.SORTED_PARTIAL_REDUCE);
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            ReduceCombineDriver driver = new ReduceCombineDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Assert.assertEquals((long)0L, (long)result.getList().size());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReduceDriverImmutable() {
        try {
            TestTaskContext context = new TestTaskContext(0x100000L);
            context.getTaskConfig().setRelativeMemoryDriver(0.5);
            List<Tuple2<String, Integer>> data = DriverTestData.createReduceImmutableData();
            Collections.shuffle(data);
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), (TypeSerializer)typeInfo.createSerializer(new ExecutionConfig()));
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setDriverStrategy(DriverStrategy.SORTED_PARTIAL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            context.setUdf(new ConcatSumFirstReducer());
            ReduceCombineDriver driver = new ReduceCombineDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Object[] res = result.getList().toArray();
            Object[] expected = DriverTestData.createReduceImmutableDataGroupedResult().toArray();
            DriverTestData.compareTupleArrays(expected, res);
            context = new TestTaskContext(0x100000L);
            context.getTaskConfig().setRelativeMemoryDriver(0.5);
            data = DriverTestData.createReduceImmutableData();
            Collections.shuffle(data);
            typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            input = new RegularToMutableObjectIterator(data.iterator(), (TypeSerializer)typeInfo.createSerializer(new ExecutionConfig()));
            comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setDriverStrategy(DriverStrategy.SORTED_PARTIAL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            context.setUdf(new ConcatSumSecondReducer());
            driver = new ReduceCombineDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            res = result.getList().toArray();
            expected = DriverTestData.createReduceImmutableDataGroupedResult().toArray();
            DriverTestData.compareTupleArrays(expected, res);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReduceDriverMutable() {
        try {
            TestTaskContext context = new TestTaskContext(0x100000L);
            context.getTaskConfig().setRelativeMemoryDriver(0.5);
            List<Tuple2<StringValue, IntValue>> data = DriverTestData.createReduceMutableData();
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), (TypeSerializer)typeInfo.createSerializer(new ExecutionConfig()));
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setDriverStrategy(DriverStrategy.SORTED_PARTIAL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            context.setUdf(new ConcatSumFirstMutableReducer());
            ReduceCombineDriver driver = new ReduceCombineDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Object[] res = result.getList().toArray();
            Object[] expected = DriverTestData.createReduceMutableDataGroupedResult().toArray();
            DriverTestData.compareTupleArrays(expected, res);
            context = new TestTaskContext(0x100000L);
            context.getTaskConfig().setRelativeMemoryDriver(0.5);
            data = DriverTestData.createReduceMutableData();
            typeInfo = (TupleTypeInfo)TypeExtractor.getForObject(data.get(0));
            input = new RegularToMutableObjectIterator(data.iterator(), (TypeSerializer)typeInfo.createSerializer(new ExecutionConfig()));
            comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            result = new GatheringCollector(typeInfo.createSerializer(new ExecutionConfig()));
            context.setDriverStrategy(DriverStrategy.SORTED_PARTIAL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer(new ExecutionConfig()));
            context.setComparator1(comparator);
            context.setCollector(result);
            context.setUdf(new ConcatSumSecondMutableReducer());
            driver = new ReduceCombineDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            res = result.getList().toArray();
            expected = DriverTestData.createReduceMutableDataGroupedResult().toArray();
            DriverTestData.compareTupleArrays(expected, res);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static final class ConcatSumSecondMutableReducer
    extends RichReduceFunction<Tuple2<StringValue, IntValue>> {
        public Tuple2<StringValue, IntValue> reduce(Tuple2<StringValue, IntValue> value1, Tuple2<StringValue, IntValue> value2) {
            ((StringValue)value2.f0).setValue((CharSequence)(((StringValue)value1.f0).getValue() + ((StringValue)value2.f0).getValue()));
            ((IntValue)value2.f1).setValue(((IntValue)value1.f1).getValue() + ((IntValue)value2.f1).getValue());
            return value2;
        }
    }

    public static final class ConcatSumFirstMutableReducer
    extends RichReduceFunction<Tuple2<StringValue, IntValue>> {
        public Tuple2<StringValue, IntValue> reduce(Tuple2<StringValue, IntValue> value1, Tuple2<StringValue, IntValue> value2) {
            ((StringValue)value1.f0).setValue((CharSequence)(((StringValue)value1.f0).getValue() + ((StringValue)value2.f0).getValue()));
            ((IntValue)value1.f1).setValue(((IntValue)value1.f1).getValue() + ((IntValue)value2.f1).getValue());
            return value1;
        }
    }

    public static final class ConcatSumSecondReducer
    extends RichReduceFunction<Tuple2<String, Integer>> {
        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) {
            value2.f0 = (String)value1.f0 + (String)value2.f0;
            value2.f1 = (Integer)value1.f1 + (Integer)value2.f1;
            return value2;
        }
    }

    public static final class ConcatSumFirstReducer
    extends RichReduceFunction<Tuple2<String, Integer>> {
        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) {
            value1.f0 = (String)value1.f0 + (String)value2.f0;
            value1.f1 = (Integer)value1.f1 + (Integer)value2.f1;
            return value1;
        }
    }
}

