/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import java.util.Collections;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class MetricCollectionResponseBodyTest
extends RestResponseMarshallingTestBase<MetricCollectionResponseBody> {
    private static final String TEST_METRIC_NAME = "metric1";
    private static final String TEST_METRIC_VALUE = "1000";

    @Override
    protected Class<MetricCollectionResponseBody> getTestResponseClass() {
        return MetricCollectionResponseBody.class;
    }

    @Override
    protected MetricCollectionResponseBody getTestResponseInstance() {
        return new MetricCollectionResponseBody(Collections.singleton(new Metric(TEST_METRIC_NAME, TEST_METRIC_VALUE)));
    }

    @Override
    protected void assertOriginalEqualsToUnmarshalled(MetricCollectionResponseBody expected, MetricCollectionResponseBody actual) {
        MatcherAssert.assertThat((Object)actual.getMetrics(), (Matcher)Matchers.hasSize((int)1));
        Metric metric = (Metric)actual.getMetrics().iterator().next();
        MatcherAssert.assertThat((Object)metric.getId(), (Matcher)Matchers.equalTo((Object)TEST_METRIC_NAME));
        MatcherAssert.assertThat((Object)metric.getValue(), (Matcher)Matchers.equalTo((Object)TEST_METRIC_VALUE));
    }

    @Test
    public void testNullValueNotSerialized() throws Exception {
        String json = RestMapperUtils.getStrictObjectMapper().writeValueAsString((Object)new MetricCollectionResponseBody(Collections.singleton(new Metric(TEST_METRIC_NAME))));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\"value\"")));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\"metrics\"")));
    }
}

