/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import org.apache.flink.runtime.rest.messages.json.SerializedThrowableDeserializer;
import org.apache.flink.runtime.rest.messages.json.SerializedThrowableSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializedThrowableSerializerTest
extends TestLogger {
    private ObjectMapper objectMapper = new ObjectMapper();

    @Before
    public void setUp() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(SerializedThrowable.class, (JsonDeserializer)new SerializedThrowableDeserializer());
        simpleModule.addSerializer(SerializedThrowable.class, (JsonSerializer)new SerializedThrowableSerializer());
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)simpleModule);
    }

    @Test
    public void testSerializationDeserialization() throws Exception {
        String lastExceptionMessage = "message";
        String causeMessage = "cause";
        SerializedThrowable serializedThrowable = new SerializedThrowable((Throwable)new RuntimeException("message", new RuntimeException("cause")));
        String json = this.objectMapper.writeValueAsString((Object)serializedThrowable);
        SerializedThrowable deserializedSerializedThrowable = (SerializedThrowable)this.objectMapper.readValue(json, SerializedThrowable.class);
        Assert.assertThat((Object)deserializedSerializedThrowable.getMessage(), (Matcher)Matchers.equalTo((Object)"message"));
        Assert.assertThat((Object)deserializedSerializedThrowable.getFullStringifiedStackTrace(), (Matcher)Matchers.equalTo((Object)serializedThrowable.getFullStringifiedStackTrace()));
        Assert.assertThat((Object)deserializedSerializedThrowable.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"cause"));
        Assert.assertThat((Object)deserializedSerializedThrowable.getCause(), (Matcher)Matchers.instanceOf(SerializedThrowable.class));
    }
}

