/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;

public class TestRestServerEndpoint
extends RestServerEndpoint {
    private final List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers;

    public static Builder builder(RestServerEndpointConfiguration configuration) {
        return new Builder(configuration);
    }

    private TestRestServerEndpoint(RestServerEndpointConfiguration configuration, List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) throws IOException {
        super(configuration);
        this.handlers = handlers;
    }

    protected List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> ignore) {
        return this.handlers;
    }

    protected void startInternal() {
    }

    public static class Builder {
        private final RestServerEndpointConfiguration configuration;
        private final List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers = new ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>>();

        private Builder(RestServerEndpointConfiguration configuration) {
            this.configuration = configuration;
        }

        public Builder withHandler(RestHandlerSpecification messageHeaders, ChannelInboundHandler handler) {
            this.handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)messageHeaders, (Object)handler));
            return this;
        }

        public Builder withHandler(AbstractRestHandler<?, ?, ?, ?> handler) {
            this.handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)handler.getMessageHeaders(), handler));
            return this;
        }

        public TestRestServerEndpoint build() throws IOException {
            return new TestRestServerEndpoint(this.configuration, this.handlers);
        }

        public TestRestServerEndpoint buildAndStart() throws Exception {
            TestRestServerEndpoint serverEndpoint = this.build();
            serverEndpoint.start();
            return serverEndpoint;
        }
    }
}

