/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MessageSerializationTest
extends TestLogger {
    private static RpcService akkaRpcService1;
    private static RpcService akkaRpcService2;
    private static final Time timeout;
    private static final int maxFrameSize = 32000;

    @BeforeClass
    public static void setup() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setString(AkkaOptions.FRAMESIZE, "32000b");
        akkaRpcService1 = AkkaRpcServiceUtils.remoteServiceBuilder((Configuration)configuration, (String)"localhost", (int)0).createAndStart();
        akkaRpcService2 = AkkaRpcServiceUtils.remoteServiceBuilder((Configuration)configuration, (String)"localhost", (int)0).createAndStart();
    }

    @AfterClass
    public static void teardown() throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<CompletableFuture> terminationFutures = new ArrayList<CompletableFuture>(2);
        terminationFutures.add(akkaRpcService1.stopService());
        terminationFutures.add(akkaRpcService2.stopService());
        FutureUtils.waitForAll(terminationFutures).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testNonSerializableLocalMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint(akkaRpcService1, linkedBlockingQueue);
        testEndpoint.start();
        TestGateway testGateway = (TestGateway)testEndpoint.getSelfGateway(TestGateway.class);
        NonSerializableObject expected = new NonSerializableObject(42);
        testGateway.foobar(expected);
        Assert.assertThat((Object)linkedBlockingQueue.take(), (Matcher)Is.is((Object)expected));
    }

    @Test(expected=IOException.class)
    public void testNonSerializableRemoteMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint(akkaRpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        CompletableFuture remoteGatewayFuture = akkaRpcService2.connect(address, TestGateway.class);
        TestGateway remoteGateway = (TestGateway)remoteGatewayFuture.get(timeout.getSize(), timeout.getUnit());
        remoteGateway.foobar(new Object());
        Assert.fail((String)"Should have failed because Object is not serializable.");
    }

    @Test
    public void testSerializableRemoteMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint(akkaRpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        CompletableFuture remoteGatewayFuture = akkaRpcService2.connect(address, TestGateway.class);
        TestGateway remoteGateway = (TestGateway)remoteGatewayFuture.get(timeout.getSize(), timeout.getUnit());
        int expected = 42;
        remoteGateway.foobar(expected);
        Assert.assertThat((Object)linkedBlockingQueue.take(), (Matcher)Is.is((Object)expected));
    }

    @Test(expected=IOException.class)
    public void testMaximumFramesizeRemoteMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint(akkaRpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        CompletableFuture remoteGatewayFuture = akkaRpcService2.connect(address, TestGateway.class);
        TestGateway remoteGateway = (TestGateway)remoteGatewayFuture.get(timeout.getSize(), timeout.getUnit());
        int bufferSize = 32001;
        byte[] buffer = new byte[bufferSize];
        remoteGateway.foobar(buffer);
        Assert.fail((String)"Should have failed due to exceeding the maximum framesize.");
    }

    static {
        timeout = Time.seconds((long)10L);
    }

    private static class NonSerializableObject {
        private final Object object = new Object();
        private final int value;

        NonSerializableObject(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NonSerializableObject) {
                NonSerializableObject nonSerializableObject = (NonSerializableObject)obj;
                return this.value == nonSerializableObject.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value * 41;
        }
    }

    private static class TestEndpoint
    extends RpcEndpoint
    implements TestGateway {
        private final LinkedBlockingQueue<Object> queue;

        protected TestEndpoint(RpcService rpcService, LinkedBlockingQueue<Object> queue) {
            super(rpcService);
            this.queue = queue;
        }

        @Override
        public void foobar(Object object) throws InterruptedException {
            this.queue.put(object);
        }
    }

    private static interface TestGateway
    extends RpcGateway {
        public void foobar(Object var1) throws IOException, InterruptedException;
    }
}

