/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.scala.FlinkILoop;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class ScalaShellEnvironment
extends ExecutionEnvironment {
    private final List<URL> jarFiles;
    private final FlinkILoop flinkILoop;

    public ScalaShellEnvironment(Configuration configuration, FlinkILoop flinkILoop, String ... jarFiles) {
        super(ScalaShellEnvironment.validateAndGetConfiguration(configuration));
        this.flinkILoop = (FlinkILoop)((Object)Preconditions.checkNotNull((Object)((Object)flinkILoop)));
        this.jarFiles = (List)Preconditions.checkNotNull((Object)JarUtils.getJarFiles((String[])jarFiles));
    }

    private static Configuration validateAndGetConfiguration(Configuration configuration) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The RemoteEnvironment cannot be instantiated when running in a pre-defined context (such as Command Line Client, Scala Shell, or TestEnvironment)");
        }
        return (Configuration)Preconditions.checkNotNull((Object)configuration);
    }

    public JobClient executeAsync(String jobName) throws Exception {
        this.updateDependencies();
        return super.executeAsync(jobName);
    }

    private void updateDependencies() throws Exception {
        Configuration configuration = this.getConfiguration();
        Preconditions.checkState((boolean)configuration.getBoolean(DeploymentOptions.ATTACHED), (Object)"Only ATTACHED mode is supported by the scala shell.");
        List<URL> updatedJarFiles = this.getUpdatedJarFiles();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, updatedJarFiles, URL::toString);
    }

    private List<URL> getUpdatedJarFiles() throws MalformedURLException {
        URL jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        ArrayList<URL> allJarFiles = new ArrayList<URL>(this.jarFiles);
        allJarFiles.add(jarUrl);
        return allJarFiles;
    }

    public static void disableAllContextAndOtherEnvironments() {
        ScalaShellEnvironment.initializeContextEnvironment(() -> {
            throw new UnsupportedOperationException("Execution Environment is already defined for this shell.");
        });
    }

    public static void resetContextEnvironments() {
        ExecutionEnvironment.resetContextEnvironment();
    }
}

