/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.scala.FieldAccessFinder;
import org.apache.flink.api.scala.FieldAccessFinder$;
import org.apache.flink.api.scala.InnerClosureFinder;
import org.apache.flink.api.scala.ReturnStatementFinder;
import org.apache.flink.api.scala.ReturnStatementFinder$;
import org.apache.flink.shaded.asm6.org.objectweb.asm.ClassReader;
import org.apache.flink.shaded.asm6.org.objectweb.asm.ClassVisitor;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.util.Properties$;
import sun.reflect.ReflectionFactory;

@Internal
public final class ClosureCleaner$ {
    public static final ClosureCleaner$ MODULE$;
    private final Logger LOG;
    private final boolean isScala2_11;

    static {
        new ClosureCleaner$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    private boolean isScala2_11() {
        return this.isScala2_11;
    }

    public ClassReader getClassReader(Class<?> cls) {
        ClassReader classReader;
        String className = new StringBuilder().append((Object)cls.getName().replaceFirst("^.*\\.", "")).append((Object)".class").toString();
        InputStream resourceStream = cls.getResourceAsStream(className);
        if (resourceStream == null) {
            classReader = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
            this.copyStream(resourceStream, baos, true);
            classReader = new ClassReader((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        return classReader;
    }

    public boolean org$apache$flink$api$scala$ClosureCleaner$$isClosure(Class<?> cls) {
        return cls.getName().contains("$anonfun$");
    }

    public Tuple2<List<Class<?>>, List<Object>> org$apache$flink$api$scala$ClosureCleaner$$getOuterClassesAndObjects(Object obj) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Tuple2 tuple2;
            Object object = new Object();
            try {
                Predef$.MODULE$.refArrayOps((Object[])obj.getClass().getDeclaredFields()).withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Field f) {
                        String string = f.getName();
                        String string2 = "$outer";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                }).foreach((Function1)new Serializable(obj, object){
                    public static final long serialVersionUID = 0L;
                    private final Object obj$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Field f) {
                        f.setAccessible(true);
                        Object outer = f.get(this.obj$1);
                        if (outer == null) {
                            return;
                        }
                        if (ClosureCleaner$.MODULE$.org$apache$flink$api$scala$ClosureCleaner$$isClosure(f.getType())) {
                            Tuple2<List<Class<?>>, List<Object>> recurRet = ClosureCleaner$.MODULE$.org$apache$flink$api$scala$ClosureCleaner$$getOuterClassesAndObjects(outer);
                            Class<?> clazz = f.getType();
                            Object object = outer;
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Tuple2((Object)((List)recurRet._1()).$colon$colon(clazz), (Object)((List)recurRet._2()).$colon$colon(object)));
                        }
                        Class<?> clazz = f.getType();
                        Object object = outer;
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Tuple2((Object)Nil$.MODULE$.$colon$colon(clazz), (Object)Nil$.MODULE$.$colon$colon(object)));
                    }
                    {
                        this.obj$1 = obj$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                tuple2 = (Tuple2)nonLocalReturnControl2.value();
            }
            return tuple2;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    private List<Class<?>> getInnerClosureClasses(Object obj) {
        Set seen = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{obj.getClass()}));
        Stack stack = (Stack)Stack$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{obj.getClass()}));
        while (!stack.isEmpty()) {
            void var2_2;
            void var3_3;
            ClassReader cr = this.getClassReader((Class)var3_3.pop());
            if (cr == null) continue;
            Set set = Set$.MODULE$.empty();
            cr.accept((ClassVisitor)new InnerClosureFinder(set), 0);
            set.$minus$minus((GenTraversableOnce)var2_2).foreach((Function1)new Serializable((Set)var2_2, (Stack)var3_3){
                public static final long serialVersionUID = 0L;
                private final Set seen$1;
                private final Stack stack$1;

                public final Stack<Class<?>> apply(Class<?> cls) {
                    this.seen$1.$plus$eq(cls);
                    return this.stack$1.push(cls);
                }
                {
                    this.seen$1 = seen$1;
                    this.stack$1 = stack$1;
                }
            });
        }
        return seen.$minus(obj.getClass()).toList();
    }

    private void initAccessedFields(Map<Class<?>, Set<String>> accessedFields, Seq<Class<?>> outerClasses) {
        outerClasses.foreach((Function1)new Serializable(accessedFields){
            public static final long serialVersionUID = 0L;
            private final Map accessedFields$1;

            public final void apply(Class<?> cls) {
                Class<?> currentClass = cls;
                Predef$.MODULE$.assert(currentClass != null, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "The outer class can't be null.";
                    }
                });
                while (currentClass != null) {
                    this.accessedFields$1.update(currentClass, (Object)Set$.MODULE$.empty());
                    currentClass = currentClass.getSuperclass();
                }
                return;
            }
            {
                this.accessedFields$1 = accessedFields$1;
            }
        });
    }

    private void setAccessedFields(Class<?> outerClass, Object clone2, Object obj, Map<Class<?>, Set<String>> accessedFields) {
        ((IterableLike)accessedFields.apply(outerClass)).foreach((Function1)new Serializable(outerClass, clone2, obj){
            public static final long serialVersionUID = 0L;
            private final Class outerClass$1;
            private final Object clone$1;
            private final Object obj$2;

            public final void apply(String fieldName) {
                Field field = this.outerClass$1.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(this.obj$2);
                field.set(this.clone$1, value);
            }
            {
                this.outerClass$1 = outerClass$1;
                this.clone$1 = clone$1;
                this.obj$2 = obj$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Object org$apache$flink$api$scala$ClosureCleaner$$cloneAndSetFields(Object parent, Object obj, Class<?> outerClass, Map<Class<?>, Set<String>> accessedFields) {
        Object clone2 = this.instantiateClass(outerClass, parent);
        Class<?> currentClass = outerClass;
        Predef$.MODULE$.assert(currentClass != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The outer class can't be null.";
            }
        });
        while (currentClass != null) {
            void var5_5;
            Class clazz;
            this.setAccessedFields(clazz, var5_5, obj, accessedFields);
            clazz = clazz.getSuperclass();
        }
        return clone2;
    }

    public void clean(Object closure, boolean checkSerializable, ExecutionConfig.ClosureCleanerLevel cleanLevel) {
        ExecutionConfig.ClosureCleanerLevel closureCleanerLevel = cleanLevel;
        ExecutionConfig.ClosureCleanerLevel closureCleanerLevel2 = ExecutionConfig.ClosureCleanerLevel.RECURSIVE;
        boolean cleanTransitively = !(closureCleanerLevel != null ? !closureCleanerLevel.equals(closureCleanerLevel2) : closureCleanerLevel2 != null);
        this.org$apache$flink$api$scala$ClosureCleaner$$clean(closure, checkSerializable, cleanTransitively, Map$.MODULE$.empty());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<SerializedLambda> getSerializedLambda(Object closure) {
        None$ none$;
        boolean isClosureCandidate;
        if (this.isScala2_11()) {
            return None$.MODULE$;
        }
        boolean bl = isClosureCandidate = closure.getClass().isSynthetic() && Predef$.MODULE$.refArrayOps((Object[])closure.getClass().getInterfaces()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Class<?> x$5) {
                String string = x$5.getName();
                String string2 = "scala.Serializable";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        if (!isClosureCandidate) {
            none$ = None$.MODULE$;
            return none$;
        }
        try {
            none$ = Option$.MODULE$.apply((Object)this.inspect(closure));
            return none$;
        }
        catch (Exception exception) {
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug("Closure is not a serialized lambda.", (Throwable)exception);
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private SerializedLambda inspect(Object closure) {
        Method writeReplace = closure.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        writeReplace.setAccessible(true);
        return (SerializedLambda)writeReplace.invoke(closure, new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void org$apache$flink$api$scala$ClosureCleaner$$clean(Object func, boolean checkSerializable, boolean cleanTransitively, Map<Class<?>, Set<String>> accessedFields) {
        Option<SerializedLambda> lambdaFunc = this.getSerializedLambda(func);
        if (!this.org$apache$flink$api$scala$ClosureCleaner$$isClosure(func.getClass()) && lambdaFunc.isEmpty()) {
            this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a closure; got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{func.getClass().getName()})));
            return;
        }
        if (func == null) {
            return;
        }
        if (lambdaFunc.isEmpty()) {
            Tuple2 tuple2;
            this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+++ Cleaning closure ", " (", ") +++"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{func, func.getClass().getName()})));
            List<Class<?>> innerClasses = this.getInnerClosureClasses(func);
            Tuple2<List<Class<?>>, List<Object>> tuple22 = this.org$apache$flink$api$scala$ClosureCleaner$$getOuterClassesAndObjects(func);
            if (tuple22 == null) throw new MatchError(tuple22);
            List outerClasses = (List)tuple22._1();
            List outerObjects = (List)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)outerClasses, (Object)outerObjects);
            List outerClasses2 = (List)tuple23._1();
            List outerObjects2 = (List)tuple23._2();
            Field[] declaredFields = func.getClass().getDeclaredFields();
            Method[] declaredMethods = func.getClass().getDeclaredMethods();
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + declared fields: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])declaredFields).size())})));
                Predef$.MODULE$.refArrayOps((Object[])declaredFields).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Field f) {
                        ClosureCleaner$.MODULE$.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"     ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f})));
                    }
                });
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + declared methods: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])declaredMethods).size())})));
                Predef$.MODULE$.refArrayOps((Object[])declaredMethods).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Method m) {
                        ClosureCleaner$.MODULE$.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"     ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m})));
                    }
                });
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + inner classes: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)innerClasses.size())})));
                innerClasses.foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Class<?> c) {
                        ClosureCleaner$.MODULE$.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"     ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getName()})));
                    }
                });
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + outer classes: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outerClasses2.size())})));
                outerClasses2.foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Class<?> c) {
                        ClosureCleaner$.MODULE$.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"     ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getName()})));
                    }
                });
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + outer objects: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outerObjects2.size())})));
                outerObjects2.foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Object o) {
                        ClosureCleaner$.MODULE$.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"     ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o})));
                    }
                });
            }
            this.getClassReader(func.getClass()).accept((ClassVisitor)new ReturnStatementFinder(ReturnStatementFinder$.MODULE$.$lessinit$greater$default$1()), 0);
            if (accessedFields.isEmpty()) {
                this.LOG().debug(" + populating accessed fields because this is the starting closure");
                this.initAccessedFields(accessedFields, (Seq<Class<?>>)outerClasses2);
                Class<?> clazz = func.getClass();
                innerClasses.$colon$colon(clazz).foreach((Function1)new Serializable(cleanTransitively, accessedFields){
                    public static final long serialVersionUID = 0L;
                    private final boolean cleanTransitively$1;
                    private final Map accessedFields$2;

                    public final void apply(Class<?> cls) {
                        ClosureCleaner$.MODULE$.getClassReader(cls).accept((ClassVisitor)new FieldAccessFinder(this.accessedFields$2, this.cleanTransitively$1, FieldAccessFinder$.MODULE$.$lessinit$greater$default$3(), FieldAccessFinder$.MODULE$.$lessinit$greater$default$4()), 0);
                    }
                    {
                        this.cleanTransitively$1 = cleanTransitively$1;
                        this.accessedFields$2 = accessedFields$2;
                    }
                });
            }
            this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + fields accessed by starting closure: "})).s((Seq)Nil$.MODULE$)).append((Object)BoxesRunTime.boxToInteger((int)accessedFields.size())).toString());
            accessedFields.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Class<?>, Set<String>> f) {
                    ClosureCleaner$.MODULE$.LOG().debug(new StringBuilder().append((Object)"     ").append(f).toString());
                }
            });
            List outerPairs = ((List)outerClasses2.zip((GenIterable)outerObjects2, List$.MODULE$.canBuildFrom())).reverse();
            ObjectRef parent = ObjectRef.create(null);
            if (outerPairs.nonEmpty()) {
                Tuple2 tuple24;
                Tuple2 tuple25 = (Tuple2)outerPairs.head();
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                Class outermostClass = (Class)tuple25._1();
                Object outermostObject = tuple25._2();
                Tuple2 tuple26 = tuple24 = new Tuple2((Object)outermostClass, outermostObject);
                Class outermostClass2 = (Class)tuple26._1();
                Object outermostObject2 = tuple26._2();
                if (this.org$apache$flink$api$scala$ClosureCleaner$$isClosure(outermostClass2)) {
                    this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + outermost object is a closure, so we clone it: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outerPairs.head()})));
                } else if (outermostClass2.getName().startsWith("$line")) {
                    this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + outermost object is a REPL line object, so we clone it: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outerPairs.head()})));
                } else {
                    this.LOG().debug(new StringBuilder().append((Object)" + outermost object is not a closure or REPL line object,so do not clone it: ").append(outerPairs.head()).toString());
                    parent.elem = outermostObject2;
                    outerPairs = (List)outerPairs.tail();
                }
            } else {
                this.LOG().debug(" + there are no enclosing objects!");
            }
            outerPairs.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Class<?>, Object> check$ifrefutable$1) {
                    Tuple2<Class<?>, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(cleanTransitively, accessedFields, parent){
                public static final long serialVersionUID = 0L;
                private final boolean cleanTransitively$1;
                private final Map accessedFields$2;
                private final ObjectRef parent$1;

                public final void apply(Tuple2<Class<?>, Object> x$9) {
                    Tuple2<Class<?>, Object> tuple2 = x$9;
                    if (tuple2 != null) {
                        Class cls = (Class)tuple2._1();
                        Object obj = tuple2._2();
                        ClosureCleaner$.MODULE$.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + cloning the object ", " of class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obj, cls.getName()})));
                        Object clone2 = ClosureCleaner$.MODULE$.org$apache$flink$api$scala$ClosureCleaner$$cloneAndSetFields(this.parent$1.elem, obj, cls, this.accessedFields$2);
                        if (this.cleanTransitively$1 && ClosureCleaner$.MODULE$.org$apache$flink$api$scala$ClosureCleaner$$isClosure(clone2.getClass())) {
                            ClosureCleaner$.MODULE$.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + cleaning cloned closure ", " recursively (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clone2, cls.getName()})));
                            ClosureCleaner$.MODULE$.org$apache$flink$api$scala$ClosureCleaner$$clean(clone2, false, this.cleanTransitively$1, this.accessedFields$2);
                        }
                        this.parent$1.elem = clone2;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.cleanTransitively$1 = cleanTransitively$1;
                    this.accessedFields$2 = accessedFields$2;
                    this.parent$1 = parent$1;
                }
            });
            if (parent.elem != null) {
                Field field = func.getClass().getDeclaredField("$outer");
                field.setAccessible(true);
                if (accessedFields.contains(func.getClass()) && !((SetLike)accessedFields.apply(func.getClass())).contains((Object)"$outer")) {
                    this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" + the starting closure doesn't actually need ", ", so we null it out"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parent.elem})));
                    field.set(func, null);
                } else {
                    field.set(func, parent.elem);
                }
            }
            this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" +++ closure ", " (", ") is now cleaned +++"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{func, func.getClass().getName()})));
        } else {
            this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning lambda: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SerializedLambda)lambdaFunc.get()).getImplMethodName()})));
            Class<?> captClass = Class.forName(((SerializedLambda)lambdaFunc.get()).getCapturingClass().replace('/', '.'), false, Thread.currentThread().getContextClassLoader());
            this.getClassReader(captClass).accept((ClassVisitor)new ReturnStatementFinder((Option<String>)new Some((Object)((SerializedLambda)lambdaFunc.get()).getImplMethodName())), 0);
            this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" +++ Lambda closure (", ") is now cleaned +++"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SerializedLambda)lambdaFunc.get()).getImplMethodName()})));
        }
        if (!checkSerializable) return;
        this.ensureSerializable(func);
    }

    public boolean clean$default$2() {
        return true;
    }

    public ExecutionConfig.ClosureCleanerLevel clean$default$3() {
        return ExecutionConfig.ClosureCleanerLevel.RECURSIVE;
    }

    public void ensureSerializable(Object func) {
        try {
            InstantiationUtil.serializeObject((Object)func);
            return;
        }
        catch (Exception exception) {
            throw new InvalidProgramException("Task not serializable", (Throwable)exception);
        }
    }

    private Object instantiateClass(Class<?> cls, Object enclosingObject) {
        ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
        Constructor parentCtor = Object.class.getDeclaredConstructor(new Class[0]);
        Constructor<?> newCtor = rf.newConstructorForSerialization(cls, parentCtor);
        Object obj = newCtor.newInstance(new Object[0]);
        if (enclosingObject != null) {
            Field field = cls.getDeclaredField("$outer");
            field.setAccessible(true);
            field.set(obj, enclosingObject);
        }
        return obj;
    }

    public long copyStream(InputStream in, OutputStream out, boolean closeStreams) {
        long l;
        block13: {
            try {
                long count;
                if (in instanceof FileInputStream && out instanceof FileOutputStream) {
                    FileChannel inChannel = ((FileInputStream)in).getChannel();
                    FileChannel outChannel = ((FileOutputStream)out).getChannel();
                    long size = inChannel.size();
                    for (count = 0L; count < size; count += inChannel.transferTo(count, size - count, outChannel)) {
                    }
                } else {
                    byte[] buf = new byte[8192];
                    int n = 0;
                    while (n != -1) {
                        n = in.read(buf);
                        if (n == -1) continue;
                        out.write(buf, 0, n);
                        count += (long)n;
                    }
                }
                l = count;
                if (!closeStreams) break block13;
            }
            catch (Throwable throwable) {
                if (closeStreams) {
                    in.close();
                }
                throw throwable;
                finally {
                    out.close();
                }
            }
            in.close();
        }
        return l;
        finally {
            out.close();
        }
    }

    public boolean copyStream$default$3() {
        return false;
    }

    private ClosureCleaner$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
        this.isScala2_11 = Properties$.MODULE$.versionString().contains("2.11");
    }
}

