/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.apache.curator.framework.imps;

import org.apache.flink.hadoop.shaded.org.apache.curator.TimeTrace;
import org.apache.flink.hadoop.shaded.org.apache.curator.framework.api.CuratorEventType;
import org.apache.flink.hadoop.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.flink.hadoop.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.flink.hadoop.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.flink.hadoop.shaded.org.apache.curator.framework.imps.OperationAndData;
import org.apache.zookeeper.AsyncCallback;

class BackgroundSyncImpl
implements BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private final Object context;

    BackgroundSyncImpl(CuratorFrameworkImpl client, Object context) {
        this.client = client;
        this.context = context;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("BackgroundSyncImpl");
        this.client.getZooKeeper().sync(operationAndData.getData(), new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                trace.commit();
                CuratorEventImpl event = new CuratorEventImpl(BackgroundSyncImpl.this.client, CuratorEventType.SYNC, rc, path, null, ctx, null, null, null, null, null);
                BackgroundSyncImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        }, this.context);
    }
}

