/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.protobuf;

import org.apache.flink.hadoop.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.Channel;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.ChannelHandler;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer body = (ChannelBuffer)msg;
        int length = body.readableBytes();
        ChannelBuffer header = channel.getConfig().getBufferFactory().getBuffer(body.order(), CodedOutputStream.computeRawVarint32Size(length));
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(new ChannelBufferOutputStream(header));
        codedOutputStream.writeRawVarint32(length);
        codedOutputStream.flush();
        return ChannelBuffers.wrappedBuffer(header, body);
    }
}

