/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.flink.hadoop.shaded.com.google.protobuf.RpcController;
import org.apache.flink.hadoop.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.ha.proto.ZKFCProtocolProtos;
import org.apache.hadoop.ha.protocolPB.ZKFCProtocolPB;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

public class ZKFCProtocolClientSideTranslatorPB
implements ZKFCProtocol,
Closeable,
ProtocolTranslator {
    private static final RpcController NULL_CONTROLLER = null;
    private final ZKFCProtocolPB rpcProxy;

    public ZKFCProtocolClientSideTranslatorPB(InetSocketAddress addr, Configuration conf, SocketFactory socketFactory, int timeout) throws IOException {
        RPC.setProtocolEngine(conf, ZKFCProtocolPB.class, ProtobufRpcEngine.class);
        this.rpcProxy = RPC.getProxy(ZKFCProtocolPB.class, RPC.getProtocolVersion(ZKFCProtocolPB.class), addr, UserGroupInformation.getCurrentUser(), conf, socketFactory, timeout);
    }

    @Override
    public void cedeActive(int millisToCede) throws IOException, AccessControlException {
        try {
            ZKFCProtocolProtos.CedeActiveRequestProto req = ZKFCProtocolProtos.CedeActiveRequestProto.newBuilder().setMillisToCede(millisToCede).build();
            this.rpcProxy.cedeActive(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void gracefulFailover() throws IOException, AccessControlException {
        try {
            this.rpcProxy.gracefulFailover(NULL_CONTROLLER, ZKFCProtocolProtos.GracefulFailoverRequestProto.getDefaultInstance());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

